/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v7.content.res.AppCompatResources;
import android.util.AttributeSet;
import android.util.TypedValue;
import com.mapbox.mapboxsdk.utils.BitmapUtils;
import com.mapbox.services.android.navigation.ui.v5.R;

public class ThemeSwitcher {
    public static int retrieveThemeColor(Context context, int resId) {
        TypedValue outValue = ThemeSwitcher.resolveAttributeFromId(context, resId);
        if (outValue.type >= 28 && outValue.type <= 31) {
            return outValue.data;
        }
        return ContextCompat.getColor((Context)context, (int)outValue.resourceId);
    }

    public static Bitmap retrieveThemeMapMarker(Context context) {
        TypedValue destinationMarkerResId = ThemeSwitcher.resolveAttributeFromId(context, R.attr.navigationViewDestinationMarker);
        int markerResId = destinationMarkerResId.resourceId;
        Drawable markerDrawable = ContextCompat.getDrawable((Context)context, (int)markerResId);
        return BitmapUtils.getBitmapFromDrawable((Drawable)markerDrawable);
    }

    public static Drawable retrieveThemeOverviewDrawable(Context context) {
        TypedValue destinationMarkerResId = ThemeSwitcher.resolveAttributeFromId(context, R.attr.navigationViewRouteOverviewDrawable);
        int overviewResId = destinationMarkerResId.resourceId;
        return AppCompatResources.getDrawable((Context)context, (int)overviewResId);
    }

    public static int retrieveNavigationViewStyle(Context context, int styleResId) {
        TypedValue outValue = ThemeSwitcher.resolveAttributeFromId(context, styleResId);
        return outValue.resourceId;
    }

    static void setTheme(Context context, AttributeSet attrs) {
        boolean nightModeEnabled = ThemeSwitcher.isNightModeEnabled(context);
        if (ThemeSwitcher.shouldSetThemeFromPreferences(context)) {
            int prefLightTheme = ThemeSwitcher.retrieveThemeResIdFromPreferences(context, "navigation_view_light_theme");
            int prefDarkTheme = ThemeSwitcher.retrieveThemeResIdFromPreferences(context, "navigation_view_dark_theme");
            prefLightTheme = prefLightTheme == 0 ? R.style.NavigationViewLight : prefLightTheme;
            prefDarkTheme = prefLightTheme == 0 ? R.style.NavigationViewDark : prefDarkTheme;
            context.setTheme(nightModeEnabled ? prefDarkTheme : prefLightTheme);
            return;
        }
        TypedArray styledAttributes = context.obtainStyledAttributes(attrs, R.styleable.NavigationView);
        int lightTheme = styledAttributes.getResourceId(R.styleable.NavigationView_navigationLightTheme, R.style.NavigationViewLight);
        int darkTheme = styledAttributes.getResourceId(R.styleable.NavigationView_navigationDarkTheme, R.style.NavigationViewDark);
        styledAttributes.recycle();
        context.setTheme(nightModeEnabled ? darkTheme : lightTheme);
    }

    static String retrieveMapStyle(Context context) {
        TypedValue mapStyleAttr = ThemeSwitcher.resolveAttributeFromId(context, R.attr.navigationViewMapStyle);
        return mapStyleAttr.string.toString();
    }

    private static boolean isNightModeEnabled(Context context) {
        int currentNightMode = ThemeSwitcher.retrieveCurrentUiMode(context);
        return currentNightMode == 32;
    }

    private static int retrieveCurrentUiMode(Context context) {
        return context.getResources().getConfiguration().uiMode & 0x30;
    }

    @NonNull
    private static TypedValue resolveAttributeFromId(Context context, int resId) {
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(resId, outValue, true);
        return outValue;
    }

    private static boolean shouldSetThemeFromPreferences(Context context) {
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        return preferences.getBoolean("navigation_view_theme_preference", false);
    }

    private static int retrieveThemeResIdFromPreferences(Context context, String key) {
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        return preferences.getInt(key, 0);
    }
}

