/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5;

import android.support.annotation.Nullable;
import android.support.design.widget.BottomSheetBehavior;
import android.view.View;
import com.mapbox.api.directions.v5.models.BannerInstructions;
import com.mapbox.api.directions.v5.models.DirectionsRoute;
import com.mapbox.geojson.Point;
import com.mapbox.services.android.navigation.ui.v5.NavigationViewOptions;
import com.mapbox.services.android.navigation.ui.v5.feedback.FeedbackItem;
import com.mapbox.services.android.navigation.ui.v5.listeners.BannerInstructionsListener;
import com.mapbox.services.android.navigation.ui.v5.listeners.FeedbackListener;
import com.mapbox.services.android.navigation.ui.v5.listeners.InstructionListListener;
import com.mapbox.services.android.navigation.ui.v5.listeners.NavigationListener;
import com.mapbox.services.android.navigation.ui.v5.listeners.RouteListener;
import com.mapbox.services.android.navigation.ui.v5.listeners.SpeechAnnouncementListener;
import com.mapbox.services.android.navigation.ui.v5.voice.SpeechAnnouncement;
import com.mapbox.services.android.navigation.v5.milestone.MilestoneEventListener;
import com.mapbox.services.android.navigation.v5.navigation.MapboxNavigation;
import com.mapbox.services.android.navigation.v5.routeprogress.ProgressChangeListener;

class NavigationViewEventDispatcher {
    private ProgressChangeListener progressChangeListener;
    private MilestoneEventListener milestoneEventListener;
    private FeedbackListener feedbackListener;
    private NavigationListener navigationListener;
    private RouteListener routeListener;
    private BottomSheetBehavior.BottomSheetCallback bottomSheetCallback;
    private InstructionListListener instructionListListener;
    private SpeechAnnouncementListener speechAnnouncementListener;
    private BannerInstructionsListener bannerInstructionsListener;

    NavigationViewEventDispatcher() {
    }

    void initializeListeners(NavigationViewOptions navigationViewOptions, MapboxNavigation navigation) {
        this.assignFeedbackListener(navigationViewOptions.feedbackListener());
        this.assignNavigationListener(navigationViewOptions.navigationListener());
        this.assignRouteListener(navigationViewOptions.routeListener());
        this.assignBottomSheetCallback(navigationViewOptions.bottomSheetCallback());
        this.assignProgressChangeListener(navigationViewOptions, navigation);
        this.assignMilestoneEventListener(navigationViewOptions, navigation);
        this.assignInstructionListListener(navigationViewOptions.instructionListListener());
        this.assignSpeechAnnouncementListener(navigationViewOptions.speechAnnouncementListener());
        this.assignBannerInstructionsListener(navigationViewOptions.bannerInstructionsListener());
    }

    void onDestroy(@Nullable MapboxNavigation navigation) {
        if (navigation != null) {
            this.removeProgressChangeListener(navigation);
            this.removeMilestoneEventListener(navigation);
        }
    }

    void assignFeedbackListener(@Nullable FeedbackListener feedbackListener) {
        this.feedbackListener = feedbackListener;
    }

    void assignNavigationListener(@Nullable NavigationListener navigationListener) {
        this.navigationListener = navigationListener;
    }

    void assignRouteListener(@Nullable RouteListener routeListener) {
        this.routeListener = routeListener;
    }

    void assignBottomSheetCallback(@Nullable BottomSheetBehavior.BottomSheetCallback bottomSheetCallback) {
        this.bottomSheetCallback = bottomSheetCallback;
    }

    void assignInstructionListListener(@Nullable InstructionListListener instructionListListener) {
        this.instructionListListener = instructionListListener;
    }

    void assignSpeechAnnouncementListener(@Nullable SpeechAnnouncementListener speechAnnouncementListener) {
        this.speechAnnouncementListener = speechAnnouncementListener;
    }

    void assignBannerInstructionsListener(@Nullable BannerInstructionsListener bannerInstructionsListener) {
        this.bannerInstructionsListener = bannerInstructionsListener;
    }

    void onFeedbackOpened() {
        if (this.feedbackListener != null) {
            this.feedbackListener.onFeedbackOpened();
        }
    }

    void onFeedbackCancelled() {
        if (this.feedbackListener != null) {
            this.feedbackListener.onFeedbackCancelled();
        }
    }

    void onFeedbackSent(FeedbackItem feedbackItem) {
        if (this.feedbackListener != null) {
            this.feedbackListener.onFeedbackSent(feedbackItem);
        }
    }

    void onNavigationFinished() {
        if (this.navigationListener != null) {
            this.navigationListener.onNavigationFinished();
        }
    }

    void onCancelNavigation() {
        if (this.navigationListener != null) {
            this.navigationListener.onCancelNavigation();
        }
    }

    void onNavigationRunning() {
        if (this.navigationListener != null) {
            this.navigationListener.onNavigationRunning();
        }
    }

    boolean allowRerouteFrom(Point point) {
        return this.routeListener == null || this.routeListener.allowRerouteFrom(point);
    }

    void onOffRoute(Point point) {
        if (this.routeListener != null) {
            this.routeListener.onOffRoute(point);
        }
    }

    void onRerouteAlong(DirectionsRoute directionsRoute) {
        if (this.routeListener != null) {
            this.routeListener.onRerouteAlong(directionsRoute);
        }
    }

    void onFailedReroute(String errorMessage) {
        if (this.routeListener != null) {
            this.routeListener.onFailedReroute(errorMessage);
        }
    }

    void onArrival() {
        if (this.routeListener != null) {
            this.routeListener.onArrival();
        }
    }

    void onBottomSheetStateChanged(View bottomSheet, int newState) {
        if (this.bottomSheetCallback != null) {
            this.bottomSheetCallback.onStateChanged(bottomSheet, newState);
        }
    }

    void onInstructionListVisibilityChanged(boolean shown) {
        if (this.instructionListListener != null) {
            this.instructionListListener.onInstructionListVisibilityChanged(shown);
        }
    }

    SpeechAnnouncement onAnnouncement(SpeechAnnouncement announcement) {
        if (this.speechAnnouncementListener != null) {
            return this.speechAnnouncementListener.willVoice(announcement);
        }
        return announcement;
    }

    BannerInstructions onBannerDisplay(BannerInstructions instructions) {
        if (this.bannerInstructionsListener != null) {
            return this.bannerInstructionsListener.willDisplay(instructions);
        }
        return instructions;
    }

    private void assignProgressChangeListener(NavigationViewOptions navigationViewOptions, MapboxNavigation navigation) {
        this.progressChangeListener = navigationViewOptions.progressChangeListener();
        if (this.progressChangeListener != null) {
            navigation.addProgressChangeListener(this.progressChangeListener);
        }
    }

    private void assignMilestoneEventListener(NavigationViewOptions navigationViewOptions, MapboxNavigation navigation) {
        this.milestoneEventListener = navigationViewOptions.milestoneEventListener();
        if (this.milestoneEventListener != null) {
            navigation.addMilestoneEventListener(this.milestoneEventListener);
        }
    }

    private void removeMilestoneEventListener(MapboxNavigation navigation) {
        if (this.milestoneEventListener != null) {
            navigation.removeMilestoneEventListener(this.milestoneEventListener);
        }
    }

    private void removeProgressChangeListener(MapboxNavigation navigation) {
        if (this.progressChangeListener != null) {
            navigation.removeProgressChangeListener(this.progressChangeListener);
        }
    }
}

