/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5;

import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import android.view.View;
import android.widget.ImageView;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.services.android.navigation.ui.v5.NavigationView;
import com.mapbox.services.android.navigation.ui.v5.NavigationViewModel;
import com.mapbox.services.android.navigation.ui.v5.R;
import com.mapbox.services.android.navigation.ui.v5.utils.ViewUtils;

public class NavigationSnapshotReadyCallback
implements MapboxMap.SnapshotReadyCallback {
    private NavigationView navigationView;
    private NavigationViewModel navigationViewModel;

    NavigationSnapshotReadyCallback(NavigationView navigationView, NavigationViewModel navigationViewModel) {
        this.navigationView = navigationView;
        this.navigationViewModel = navigationViewModel;
    }

    public void onSnapshotReady(Bitmap snapshot) {
        ImageView screenshotView = this.updateScreenshotViewWithSnapshot(snapshot);
        this.updateFeedbackScreenshot();
        this.resetViewVisibility(screenshotView);
    }

    @NonNull
    private ImageView updateScreenshotViewWithSnapshot(Bitmap snapshot) {
        ImageView screenshotView = (ImageView)this.navigationView.findViewById(R.id.screenshotView);
        screenshotView.setVisibility(0);
        screenshotView.setImageBitmap(snapshot);
        return screenshotView;
    }

    private void updateFeedbackScreenshot() {
        MapView mapView = (MapView)this.navigationView.findViewById(R.id.navigationMapView);
        mapView.setVisibility(4);
        Bitmap capture = ViewUtils.captureView((View)mapView);
        String encoded = ViewUtils.encodeView(capture);
        this.navigationViewModel.updateFeedbackScreenshot(encoded);
    }

    private void resetViewVisibility(ImageView screenshotView) {
        screenshotView.setVisibility(4);
        MapView mapView = (MapView)this.navigationView.findViewById(R.id.navigationMapView);
        mapView.setVisibility(0);
    }
}

