/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.navigation.ui.v5;

import android.content.Context;
import android.support.constraint.ConstraintLayout;
import android.support.design.widget.FloatingActionButton;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.mapbox.services.android.navigation.ui.v5.MultiOnClickListener;
import com.mapbox.services.android.navigation.ui.v5.NavigationButton;
import com.mapbox.services.android.navigation.ui.v5.R;

public class FeedbackButton
extends ConstraintLayout
implements NavigationButton {
    private FloatingActionButton feedbackFab;
    private MultiOnClickListener multiOnClickListener = new MultiOnClickListener();

    public FeedbackButton(Context context) {
        this(context, null);
    }

    public FeedbackButton(Context context, AttributeSet attrs) {
        this(context, attrs, -1);
    }

    public FeedbackButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context);
    }

    @Override
    public void addOnClickListener(View.OnClickListener onClickListener) {
        this.multiOnClickListener.addListener(onClickListener);
    }

    @Override
    public void removeOnClickListener(View.OnClickListener onClickListener) {
        this.multiOnClickListener.removeListener(onClickListener);
    }

    @Override
    public void hide() {
        this.setVisibility(8);
    }

    @Override
    public void show() {
        this.setVisibility(0);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.bind();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.setupOnClickListeners();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.clearListeners();
    }

    private void setupOnClickListeners() {
        this.feedbackFab.setOnClickListener((View.OnClickListener)this.multiOnClickListener);
    }

    private void clearListeners() {
        this.multiOnClickListener.clearListeners();
        this.multiOnClickListener = null;
        this.setOnClickListener(null);
    }

    private void initialize(Context context) {
        FeedbackButton.inflate((Context)context, (int)R.layout.feedback_button_layout, (ViewGroup)this);
    }

    private void bind() {
        this.feedbackFab = (FloatingActionButton)this.findViewById(R.id.feedbackFab);
    }
}

