/*
 * Decompiled with CFR 0.152.
 */
package wiremock.webhooks.org.apache.hc.core5.http.nio.support;

import java.io.IOException;
import wiremock.webhooks.org.apache.hc.core5.annotation.Contract;
import wiremock.webhooks.org.apache.hc.core5.annotation.ThreadingBehavior;
import wiremock.webhooks.org.apache.hc.core5.http.EntityDetails;
import wiremock.webhooks.org.apache.hc.core5.http.Header;
import wiremock.webhooks.org.apache.hc.core5.http.HttpException;
import wiremock.webhooks.org.apache.hc.core5.http.HttpRequest;
import wiremock.webhooks.org.apache.hc.core5.http.HttpResponse;
import wiremock.webhooks.org.apache.hc.core5.http.message.BasicHttpResponse;
import wiremock.webhooks.org.apache.hc.core5.http.nio.AsyncDataConsumer;
import wiremock.webhooks.org.apache.hc.core5.http.nio.AsyncEntityProducer;
import wiremock.webhooks.org.apache.hc.core5.http.nio.AsyncFilterChain;
import wiremock.webhooks.org.apache.hc.core5.http.nio.AsyncFilterHandler;
import wiremock.webhooks.org.apache.hc.core5.http.protocol.HttpContext;

@Contract(threading=ThreadingBehavior.STATELESS)
public class AsyncServerExpectationFilter
implements AsyncFilterHandler {
    protected boolean verify(HttpRequest request, HttpContext context) throws HttpException {
        return true;
    }

    protected AsyncEntityProducer generateResponseContent(HttpResponse expectationFailed) throws HttpException {
        return null;
    }

    @Override
    public final AsyncDataConsumer handle(HttpRequest request, EntityDetails entityDetails, HttpContext context, AsyncFilterChain.ResponseTrigger responseTrigger, AsyncFilterChain chain) throws HttpException, IOException {
        Header h2;
        if (entityDetails != null && (h2 = request.getFirstHeader("Expect")) != null && "100-continue".equalsIgnoreCase(h2.getValue())) {
            boolean verified = this.verify(request, context);
            if (verified) {
                responseTrigger.sendInformation(new BasicHttpResponse(100));
            } else {
                BasicHttpResponse expectationFailed = new BasicHttpResponse(417);
                AsyncEntityProducer responseContentProducer = this.generateResponseContent(expectationFailed);
                responseTrigger.submitResponse(expectationFailed, responseContentProducer);
                return null;
            }
        }
        return chain.proceed(request, entityDetails, context, responseTrigger);
    }
}

