/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.extension.responsetemplating.SystemKeyAuthoriser;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsHelper;
import java.security.AccessControlException;
import wiremock.com.github.jknack.handlebars.Options;

public class SystemValueHelper
extends HandlebarsHelper<Object> {
    private final SystemKeyAuthoriser systemKeyAuthoriser;

    public SystemValueHelper(SystemKeyAuthoriser systemKeyAuthoriser) {
        this.systemKeyAuthoriser = systemKeyAuthoriser;
    }

    public String apply(Object context, Options options) {
        String key = (String)options.hash("key", "");
        String type = (String)options.hash("type", "ENVIRONMENT");
        String defaultValue = (String)options.hash("default");
        if (Strings.isEmpty(key)) {
            return this.handleError("The key cannot be empty");
        }
        if (!this.systemKeyAuthoriser.isPermitted(key)) {
            return this.handleError("Access to " + key + " is denied");
        }
        String rawValue = "";
        try {
            switch (type) {
                case "ENVIRONMENT": {
                    rawValue = this.getSystemEnvironment(key, defaultValue);
                    break;
                }
                case "PROPERTY": {
                    rawValue = this.getSystemProperties(key, defaultValue);
                }
            }
            return rawValue;
        }
        catch (AccessControlException e) {
            return this.handleError("Access to " + key + " is denied");
        }
    }

    private String getSystemEnvironment(String key, String defaultValue) {
        return System.getenv().getOrDefault(key, defaultValue);
    }

    private String getSystemProperties(String key, String defaultValue) {
        return System.getProperty(key, defaultValue);
    }
}

