/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.common.HttpClientUtils;
import com.github.tomakehurst.wiremock.common.ProxySettings;
import com.github.tomakehurst.wiremock.common.ssl.KeyStoreSettings;
import com.github.tomakehurst.wiremock.global.GlobalSettingsHolder;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.HttpClientFactory;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.http.ResponseRenderer;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.SSLException;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.entity.GzipCompressingEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.InputStreamEntity;

public class ProxyResponseRenderer
implements ResponseRenderer {
    private static final int MINUTES = 60000;
    private static final int DEFAULT_SO_TIMEOUT = 300000;
    private static final String TRANSFER_ENCODING = "transfer-encoding";
    private static final String CONTENT_ENCODING = "content-encoding";
    private static final String CONTENT_LENGTH = "content-length";
    private static final String HOST_HEADER = "host";
    public static final ImmutableList<String> FORBIDDEN_RESPONSE_HEADERS = ImmutableList.of((Object)"transfer-encoding", (Object)"connection");
    public static final ImmutableList<String> FORBIDDEN_REQUEST_HEADERS = ImmutableList.of((Object)"content-length", (Object)"transfer-encoding", (Object)"connection");
    private final CloseableHttpClient reverseProxyClient;
    private final CloseableHttpClient forwardProxyClient;
    private final boolean preserveHostHeader;
    private final String hostHeaderValue;
    private final GlobalSettingsHolder globalSettingsHolder;
    private final boolean stubCorsEnabled;

    public ProxyResponseRenderer(ProxySettings proxySettings, KeyStoreSettings trustStoreSettings, boolean preserveHostHeader, String hostHeaderValue, GlobalSettingsHolder globalSettingsHolder, boolean trustAllProxyTargets, List<String> trustedProxyTargets, boolean stubCorsEnabled) {
        this.globalSettingsHolder = globalSettingsHolder;
        this.reverseProxyClient = HttpClientFactory.createClient(1000, 300000, proxySettings, trustStoreSettings, true, Collections.emptyList(), true);
        this.forwardProxyClient = HttpClientFactory.createClient(1000, 300000, proxySettings, trustStoreSettings, trustAllProxyTargets, trustAllProxyTargets ? Collections.emptyList() : trustedProxyTargets, false);
        this.preserveHostHeader = preserveHostHeader;
        this.hostHeaderValue = hostHeaderValue;
        this.stubCorsEnabled = stubCorsEnabled;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Response render(ServeEvent serveEvent) {
        ResponseDefinition responseDefinition = serveEvent.getResponseDefinition();
        HttpUriRequest httpRequest = ProxyResponseRenderer.getHttpRequestFor(responseDefinition);
        this.addRequestHeaders((HttpRequest)httpRequest, responseDefinition);
        httpRequest.setEntity(ProxyResponseRenderer.buildEntityFrom(responseDefinition.getOriginalRequest()));
        CloseableHttpClient client = this.buildClient(serveEvent.getRequest().isBrowserProxyRequest());
        try (CloseableHttpResponse httpResponse = client.execute((ClassicHttpRequest)httpRequest);){
            Response response = Response.response().status(httpResponse.getCode()).headers(this.headersFrom((HttpResponse)httpResponse, responseDefinition)).body(HttpClientUtils.getEntityAsByteArrayAndCloseStream((ClassicHttpResponse)httpResponse)).fromProxy(true).configureDelay(this.globalSettingsHolder.get().getFixedDelay(), this.globalSettingsHolder.get().getDelayDistribution(), responseDefinition.getFixedDelayMilliseconds(), responseDefinition.getDelayDistribution()).chunkedDribbleDelay(responseDefinition.getChunkedDribbleDelay()).build();
            return response;
        }
        catch (SSLException e) {
            return this.proxyResponseError("SSL", httpRequest, e);
        }
        catch (IOException e) {
            return this.proxyResponseError("Network", httpRequest, e);
        }
    }

    private Response proxyResponseError(String type, HttpUriRequest request, Exception e) {
        return Response.response().status(500).body(type + " failure trying to make a proxied request from WireMock to " + ProxyResponseRenderer.extractUri(request) + "\r\n" + e.getMessage()).build();
    }

    private static String extractUri(HttpUriRequest request) {
        try {
            return request.getUri().toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            return request.getRequestUri();
        }
    }

    private CloseableHttpClient buildClient(boolean browserProxyRequest) {
        if (browserProxyRequest) {
            return this.forwardProxyClient;
        }
        return this.reverseProxyClient;
    }

    private HttpHeaders headersFrom(HttpResponse httpResponse, ResponseDefinition responseDefinition) {
        LinkedList<HttpHeader> httpHeaders = new LinkedList<HttpHeader>();
        for (Header header : httpResponse.getHeaders()) {
            if (!this.responseHeaderShouldBeTransferred(header.getName())) continue;
            httpHeaders.add(new HttpHeader(header.getName(), header.getValue()));
        }
        if (responseDefinition.getHeaders() != null) {
            httpHeaders.addAll(responseDefinition.getHeaders().all());
        }
        return new HttpHeaders(httpHeaders);
    }

    public static HttpUriRequest getHttpRequestFor(ResponseDefinition response) {
        RequestMethod method = response.getOriginalRequest().getMethod();
        String url = response.getProxyUrl();
        return HttpClientFactory.getHttpRequestFor(method, url);
    }

    private void addRequestHeaders(HttpRequest httpRequest, ResponseDefinition response) {
        Request originalRequest = response.getOriginalRequest();
        for (String key : originalRequest.getAllHeaderKeys()) {
            if (!ProxyResponseRenderer.requestHeaderShouldBeTransferred(key)) continue;
            if (!HOST_HEADER.equalsIgnoreCase(key) || this.preserveHostHeader) {
                List<String> values = originalRequest.header(key).values();
                for (String value : values) {
                    httpRequest.addHeader(key, (Object)value);
                }
                continue;
            }
            if (this.hostHeaderValue != null) {
                httpRequest.addHeader(key, (Object)this.hostHeaderValue);
                continue;
            }
            if (response.getProxyBaseUrl() == null) continue;
            httpRequest.addHeader(key, (Object)URI.create(response.getProxyBaseUrl()).getAuthority());
        }
        if (response.getAdditionalProxyRequestHeaders() != null) {
            for (String key : response.getAdditionalProxyRequestHeaders().keys()) {
                httpRequest.setHeader(key, (Object)response.getAdditionalProxyRequestHeaders().getHeader(key).firstValue());
            }
        }
    }

    private static boolean requestHeaderShouldBeTransferred(String key) {
        return !FORBIDDEN_REQUEST_HEADERS.contains((Object)key.toLowerCase());
    }

    private boolean responseHeaderShouldBeTransferred(String key) {
        String lowerCaseKey = key.toLowerCase();
        return !FORBIDDEN_RESPONSE_HEADERS.contains((Object)lowerCaseKey) && (!this.stubCorsEnabled || !lowerCaseKey.startsWith("access-control"));
    }

    private static HttpEntity buildEntityFrom(Request originalRequest) {
        ContentTypeHeader contentTypeHeader = originalRequest.contentTypeHeader().or("text/plain");
        ContentType contentType = ContentType.create((String)contentTypeHeader.mimeTypePart(), (String)((String)contentTypeHeader.encodingPart().or((Object)"utf-8")));
        if (originalRequest.containsHeader(TRANSFER_ENCODING) && originalRequest.header(TRANSFER_ENCODING).firstValue().equals("chunked")) {
            return ProxyResponseRenderer.applyGzipWrapperIfRequired(originalRequest, (HttpEntity)new InputStreamEntity((InputStream)new ByteArrayInputStream(originalRequest.getBody()), -1L, contentType));
        }
        return ProxyResponseRenderer.applyGzipWrapperIfRequired(originalRequest, (HttpEntity)new ByteArrayEntity(originalRequest.getBody(), ContentType.DEFAULT_BINARY));
    }

    private static HttpEntity applyGzipWrapperIfRequired(Request originalRequest, HttpEntity content) {
        if (originalRequest.containsHeader(CONTENT_ENCODING) && originalRequest.header(CONTENT_ENCODING).firstValue().contains("gzip")) {
            return new GzipCompressingEntity(content);
        }
        return content;
    }
}

