/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.direct;

import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.direct.SleepFacade;
import com.github.tomakehurst.wiremock.http.AbstractRequestHandler;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.HttpServer;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class DirectCallHttpServer
implements HttpServer {
    private static final long DEFAULT_TIMEOUT = 1000L;
    private final AdminRequestHandler adminRequestHandler;
    private final StubRequestHandler stubRequestHandler;
    private final long timeout;
    private final SleepFacade sleepFacade;

    public DirectCallHttpServer(Options options, AdminRequestHandler adminRequestHandler, StubRequestHandler stubRequestHandler) {
        this.sleepFacade = new SleepFacade();
        this.timeout = DirectCallHttpServer.getTimeout(options);
        this.adminRequestHandler = adminRequestHandler;
        this.stubRequestHandler = stubRequestHandler;
    }

    DirectCallHttpServer(SleepFacade sleepFacade, Options options, AdminRequestHandler adminRequestHandler, StubRequestHandler stubRequestHandler) {
        this.sleepFacade = sleepFacade;
        this.timeout = DirectCallHttpServer.getTimeout(options);
        this.adminRequestHandler = adminRequestHandler;
        this.stubRequestHandler = stubRequestHandler;
    }

    public Response adminRequest(Request request) {
        return this.handleRequest(request, this.adminRequestHandler);
    }

    public Response stubRequest(Request request) {
        return this.handleRequest(request, this.stubRequestHandler);
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isRunning() {
        return true;
    }

    @Override
    public int port() {
        return -1;
    }

    @Override
    public int httpsPort() {
        return -2;
    }

    private Response handleRequest(Request request, AbstractRequestHandler handler) {
        CompletableFuture responseFuture = new CompletableFuture();
        handler.handle(request, (ignored, response) -> responseFuture.complete(response));
        try {
            Response response2 = (Response)responseFuture.get(this.timeout, TimeUnit.MILLISECONDS);
            if (response2.getInitialDelay() != 0L) {
                this.sleepFacade.sleep(response2.getInitialDelay());
            }
            return response2;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Could not retrieve response from the Stub Handler", e);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Could not retrieve response from the Stub Handler", e);
        }
        catch (TimeoutException e) {
            throw new IllegalStateException(String.format("The request was not handled within the timeout of %dms", this.timeout), e);
        }
    }

    private static long getTimeout(Options options) {
        if (options.jettySettings().getStopTimeout().isPresent()) {
            return options.jettySettings().getStopTimeout().get();
        }
        return 1000L;
    }
}

