/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.admin.AdminRoutes;
import com.github.tomakehurst.wiremock.admin.AdminTask;
import com.github.tomakehurst.wiremock.admin.AdminUriTemplate;
import com.github.tomakehurst.wiremock.admin.NotFoundException;
import com.github.tomakehurst.wiremock.admin.model.PathParams;
import com.github.tomakehurst.wiremock.common.InvalidInputException;
import com.github.tomakehurst.wiremock.common.InvalidParameterException;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.NotPermittedException;
import com.github.tomakehurst.wiremock.common.Urls;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.extension.requestfilter.RequestFilter;
import com.github.tomakehurst.wiremock.http.AbstractRequestHandler;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.http.ResponseRenderer;
import com.github.tomakehurst.wiremock.security.Authenticator;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import java.net.URI;
import java.util.List;

public class AdminRequestHandler
extends AbstractRequestHandler {
    private final AdminRoutes adminRoutes;
    private final Admin admin;
    private final Authenticator authenticator;
    private final boolean requireHttps;

    public AdminRequestHandler(AdminRoutes adminRoutes, Admin admin, ResponseRenderer responseRenderer, Authenticator authenticator, boolean requireHttps, List<RequestFilter> requestFilters) {
        super(responseRenderer, requestFilters);
        this.adminRoutes = adminRoutes;
        this.admin = admin;
        this.authenticator = authenticator;
        this.requireHttps = requireHttps;
    }

    @Override
    public ServeEvent handleRequest(Request request) {
        if (this.requireHttps && !URI.create(request.getAbsoluteUrl()).getScheme().equals("https")) {
            LocalNotifier.notifier().info("HTTPS is required for admin requests, sending upgrade redirect");
            return ServeEvent.of(LoggedRequest.createFrom(request), ResponseDefinition.notPermitted("HTTPS is required for accessing the admin API"));
        }
        if (!this.authenticator.authenticate(request)) {
            LocalNotifier.notifier().info("Authentication failed for " + request.getMethod() + " " + request.getUrl());
            return ServeEvent.of(LoggedRequest.createFrom(request), ResponseDefinition.notAuthorised());
        }
        LocalNotifier.notifier().info("Admin request received:\n" + this.formatRequest(request));
        String path = Urls.getPath(AdminRequestHandler.withoutAdminRoot(request.getUrl()));
        try {
            AdminTask adminTask = this.adminRoutes.taskFor(request.getMethod(), path);
            AdminUriTemplate uriTemplate = this.adminRoutes.requestSpecForTask(adminTask.getClass()).getUriTemplate();
            PathParams pathParams = uriTemplate.parse(path);
            return ServeEvent.of(LoggedRequest.createFrom(request), adminTask.execute(this.admin, request, pathParams));
        }
        catch (NotFoundException e) {
            return ServeEvent.forUnmatchedRequest(LoggedRequest.createFrom(request));
        }
        catch (InvalidParameterException ipe) {
            return ServeEvent.forBadRequest(LoggedRequest.createFrom(request), ipe.getErrors());
        }
        catch (InvalidInputException iie) {
            return ServeEvent.forBadRequestEntity(LoggedRequest.createFrom(request), iie.getErrors());
        }
        catch (NotPermittedException npe) {
            return ServeEvent.forNotAllowedRequest(LoggedRequest.createFrom(request), npe.getErrors());
        }
        catch (Throwable t) {
            LocalNotifier.notifier().error("Unrecoverable error handling admin request", t);
            throw t;
        }
    }

    private static String withoutAdminRoot(String url) {
        return url.replace("/__admin", "");
    }
}

