/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.hc.core5.http.protocol;

import java.io.IOException;
import wiremock.org.apache.hc.core5.annotation.Contract;
import wiremock.org.apache.hc.core5.annotation.ThreadingBehavior;
import wiremock.org.apache.hc.core5.http.EntityDetails;
import wiremock.org.apache.hc.core5.http.HttpException;
import wiremock.org.apache.hc.core5.http.HttpResponse;
import wiremock.org.apache.hc.core5.http.HttpResponseInterceptor;
import wiremock.org.apache.hc.core5.http.protocol.HttpContext;
import wiremock.org.apache.hc.core5.http.protocol.HttpDateGenerator;
import wiremock.org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.SAFE)
public class ResponseDate
implements HttpResponseInterceptor {
    @Override
    public void process(HttpResponse response, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        int status = response.getCode();
        if (status >= 200 && !response.containsHeader("Date")) {
            response.setHeader("Date", HttpDateGenerator.INSTANCE.getCurrentDate());
        }
    }
}

