/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.hc.client5.http.impl.async;

import java.io.Closeable;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wiremock.org.apache.hc.client5.http.HttpRoute;
import wiremock.org.apache.hc.client5.http.async.AsyncExecRuntime;
import wiremock.org.apache.hc.client5.http.auth.AuthSchemeFactory;
import wiremock.org.apache.hc.client5.http.auth.CredentialsProvider;
import wiremock.org.apache.hc.client5.http.config.RequestConfig;
import wiremock.org.apache.hc.client5.http.cookie.CookieSpecFactory;
import wiremock.org.apache.hc.client5.http.cookie.CookieStore;
import wiremock.org.apache.hc.client5.http.impl.async.AsyncExecChainElement;
import wiremock.org.apache.hc.client5.http.impl.async.AsyncPushConsumerRegistry;
import wiremock.org.apache.hc.client5.http.impl.async.InternalAbstractHttpAsyncClient;
import wiremock.org.apache.hc.client5.http.impl.async.InternalHttpAsyncExecRuntime;
import wiremock.org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import wiremock.org.apache.hc.client5.http.protocol.HttpClientContext;
import wiremock.org.apache.hc.client5.http.routing.HttpRoutePlanner;
import wiremock.org.apache.hc.core5.annotation.Contract;
import wiremock.org.apache.hc.core5.annotation.Internal;
import wiremock.org.apache.hc.core5.annotation.ThreadingBehavior;
import wiremock.org.apache.hc.core5.http.HttpException;
import wiremock.org.apache.hc.core5.http.HttpHost;
import wiremock.org.apache.hc.core5.http.config.Lookup;
import wiremock.org.apache.hc.core5.http.nio.AsyncPushConsumer;
import wiremock.org.apache.hc.core5.http.nio.HandlerFactory;
import wiremock.org.apache.hc.core5.http2.HttpVersionPolicy;
import wiremock.org.apache.hc.core5.reactor.DefaultConnectingIOReactor;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
@Internal
public final class InternalHttpAsyncClient
extends InternalAbstractHttpAsyncClient {
    private static final Logger LOG = LoggerFactory.getLogger(InternalHttpAsyncClient.class);
    private final AsyncClientConnectionManager manager;
    private final HttpRoutePlanner routePlanner;
    private final HttpVersionPolicy versionPolicy;

    InternalHttpAsyncClient(DefaultConnectingIOReactor ioReactor, AsyncExecChainElement execChain, AsyncPushConsumerRegistry pushConsumerRegistry, ThreadFactory threadFactory, AsyncClientConnectionManager manager, HttpRoutePlanner routePlanner, HttpVersionPolicy versionPolicy, Lookup<CookieSpecFactory> cookieSpecRegistry, Lookup<AuthSchemeFactory> authSchemeRegistry, CookieStore cookieStore, CredentialsProvider credentialsProvider, RequestConfig defaultConfig, List<Closeable> closeables) {
        super(ioReactor, pushConsumerRegistry, threadFactory, execChain, cookieSpecRegistry, authSchemeRegistry, cookieStore, credentialsProvider, defaultConfig, closeables);
        this.manager = manager;
        this.routePlanner = routePlanner;
        this.versionPolicy = versionPolicy;
    }

    @Override
    AsyncExecRuntime createAsyncExecRuntime(HandlerFactory<AsyncPushConsumer> pushHandlerFactory) {
        return new InternalHttpAsyncExecRuntime(LOG, this.manager, this.getConnectionInitiator(), pushHandlerFactory, this.versionPolicy);
    }

    @Override
    HttpRoute determineRoute(HttpHost httpHost, HttpClientContext clientContext) throws HttpException {
        HttpRoute route = this.routePlanner.determineRoute(httpHost, clientContext);
        if (route.isTunnelled() && this.versionPolicy == HttpVersionPolicy.FORCE_HTTP_2) {
            throw new HttpException("HTTP/2 tunneling not supported");
        }
        return route;
    }
}

