/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.common.DataTruncationSettings;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.extension.requestfilter.ContinueAction;
import com.github.tomakehurst.wiremock.extension.requestfilter.FilterProcessor;
import com.github.tomakehurst.wiremock.extension.requestfilter.RequestFilter;
import com.github.tomakehurst.wiremock.extension.requestfilter.RequestFilterAction;
import com.github.tomakehurst.wiremock.extension.requestfilter.StopAction;
import com.github.tomakehurst.wiremock.http.HttpResponder;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestEventSource;
import com.github.tomakehurst.wiremock.http.RequestHandler;
import com.github.tomakehurst.wiremock.http.RequestListener;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.http.ResponseRenderer;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.TimeUnit;

public abstract class AbstractRequestHandler
implements RequestHandler,
RequestEventSource {
    protected List<RequestListener> listeners = Lists.newArrayList();
    protected final ResponseRenderer responseRenderer;
    protected final List<RequestFilter> requestFilters;
    private final DataTruncationSettings dataTruncationSettings;

    public AbstractRequestHandler(ResponseRenderer responseRenderer, List<RequestFilter> requestFilters, DataTruncationSettings dataTruncationSettings) {
        this.responseRenderer = responseRenderer;
        this.requestFilters = requestFilters;
        this.dataTruncationSettings = dataTruncationSettings;
    }

    @Override
    public void addRequestListener(RequestListener requestListener) {
        this.listeners.add(requestListener);
    }

    protected void beforeResponseSent(ServeEvent serveEvent, Response response) {
    }

    protected void afterResponseSent(ServeEvent serveEvent, Response response) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(Request request, HttpResponder httpResponder) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Request processedRequest = request;
        try {
            ServeEvent serveEvent;
            if (!this.requestFilters.isEmpty()) {
                RequestFilterAction requestFilterAction = FilterProcessor.processFilters(request, this.requestFilters, RequestFilterAction.continueWith(request));
                if (requestFilterAction instanceof ContinueAction) {
                    processedRequest = ((ContinueAction)requestFilterAction).getRequest();
                    serveEvent = this.handleRequest(processedRequest);
                } else {
                    serveEvent = ServeEvent.of(LoggedRequest.createFrom(request), ((StopAction)requestFilterAction).getResponseDefinition());
                }
            } else {
                serveEvent = this.handleRequest(request);
            }
            ResponseDefinition responseDefinition = serveEvent.getResponseDefinition();
            responseDefinition.setOriginalRequest(processedRequest);
            Response response = this.responseRenderer.render(serveEvent);
            response = Response.Builder.like(response).protocol(request.getProtocol()).build();
            ServeEvent completedServeEvent = serveEvent.complete(response, (int)stopwatch.elapsed(TimeUnit.MILLISECONDS), this.dataTruncationSettings);
            if (this.logRequests()) {
                LocalNotifier.notifier().info("Request received:\n" + this.formatRequest(processedRequest) + "\n\nMatched response definition:\n" + responseDefinition + "\n\nResponse:\n" + response);
            }
            for (RequestListener listener : this.listeners) {
                listener.requestReceived(processedRequest, response);
            }
            this.beforeResponseSent(completedServeEvent, response);
            stopwatch.reset();
            stopwatch.start();
            httpResponder.respond(processedRequest, response);
            completedServeEvent.afterSend((int)stopwatch.elapsed(TimeUnit.MILLISECONDS));
            this.afterResponseSent(completedServeEvent, response);
        }
        finally {
            ServeEvent.clearCurrent();
        }
        stopwatch.stop();
    }

    protected String formatRequest(Request request) {
        StringBuilder sb = new StringBuilder();
        sb.append(request.getClientIp()).append(" - ").append(request.getMethod()).append(" ").append(request.getUrl());
        if (request.isBrowserProxyRequest()) {
            sb.append(" (via browser proxy request)");
        }
        sb.append("\n\n");
        sb.append(request.getHeaders());
        if (request.getBody() != null) {
            sb.append(request.getBodyAsString()).append("\n");
        }
        return sb.toString();
    }

    protected boolean logRequests() {
        return false;
    }

    protected abstract ServeEvent handleRequest(Request var1);
}

