/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.extension.responsetemplating.RenderCache;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.io.output.StringBuilderWriter;

public class HandlebarsOptimizedTemplate {
    private final Template template;
    private String startContent;
    private String templateContent;
    private String endContent;

    public HandlebarsOptimizedTemplate(Handlebars handlebars, String content) {
        int lastDelimEndPosition;
        this.startContent = content;
        this.templateContent = "";
        this.endContent = "";
        int firstDelimStartPosition = content.indexOf("{{");
        if (firstDelimStartPosition != -1 && (lastDelimEndPosition = content.lastIndexOf("}}")) != -1) {
            this.startContent = content.substring(0, firstDelimStartPosition);
            this.templateContent = content.substring(firstDelimStartPosition, lastDelimEndPosition + "}}".length());
            this.endContent = content.substring(lastDelimEndPosition + "}}".length(), content.length());
        }
        this.template = HandlebarsOptimizedTemplate.uncheckedCompileTemplate(handlebars, this.templateContent);
    }

    private static Template uncheckedCompileTemplate(Handlebars handlebars, String templateContent) {
        try {
            return handlebars.compileInline(templateContent);
        }
        catch (IOException e) {
            return Exceptions.throwUnchecked(e, Template.class);
        }
    }

    public String apply(Object contextData) {
        RenderCache renderCache = new RenderCache();
        Context context = Context.newBuilder((Object)contextData).combine("renderCache", (Object)renderCache).build();
        return this.startContent + this.applyTemplate(context) + this.endContent;
    }

    private String applyTemplate(Context context) {
        return Exceptions.uncheck(() -> {
            StringBuilderWriter stringWriter = new StringBuilderWriter(this.template.text().length() * 2);
            this.template.apply(context, (Writer)stringWriter);
            return stringWriter.toString();
        }, String.class);
    }
}

