/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import java.util.Optional;

public class JettySettings {
    private final Optional<Integer> acceptors;
    private final Optional<Integer> acceptQueueSize;
    private final Optional<Integer> requestHeaderSize;
    private final Optional<Integer> responseHeaderSize;
    private final Optional<Long> stopTimeout;
    private final Optional<Long> idleTimeout;
    private final Optional<Long> shutdownIdleTimeout;

    private JettySettings(Optional<Integer> acceptors, Optional<Integer> acceptQueueSize, Optional<Integer> requestHeaderSize, Optional<Integer> responseHeaderSize, Optional<Long> stopTimeout, Optional<Long> idleTimeout, Optional<Long> shutdownIdleTimeout) {
        this.acceptors = acceptors;
        this.acceptQueueSize = acceptQueueSize;
        this.requestHeaderSize = requestHeaderSize;
        this.responseHeaderSize = responseHeaderSize;
        this.stopTimeout = stopTimeout;
        this.idleTimeout = idleTimeout;
        this.shutdownIdleTimeout = shutdownIdleTimeout;
    }

    public Optional<Integer> getAcceptors() {
        return this.acceptors;
    }

    public Optional<Integer> getAcceptQueueSize() {
        return this.acceptQueueSize;
    }

    public Optional<Integer> getRequestHeaderSize() {
        return this.requestHeaderSize;
    }

    public Optional<Integer> getResponseHeaderSize() {
        return this.responseHeaderSize;
    }

    public Optional<Long> getStopTimeout() {
        return this.stopTimeout;
    }

    public Optional<Long> getIdleTimeout() {
        return this.idleTimeout;
    }

    public Optional<Long> getShutdownIdleTimeout() {
        return this.shutdownIdleTimeout;
    }

    public String toString() {
        return "JettySettings{acceptors=" + this.acceptors + ", acceptQueueSize=" + this.acceptQueueSize + ", requestHeaderSize=" + this.requestHeaderSize + ", responseHeaderSize=" + this.responseHeaderSize + "}";
    }

    public static class Builder {
        private Integer acceptors;
        private Integer acceptQueueSize;
        private Integer requestHeaderSize;
        private Integer responseHeaderSize;
        private Long stopTimeout;
        private Long idleTimeout;
        private Long shutdownIdleTimeout;

        private Builder() {
        }

        public static Builder aJettySettings() {
            return new Builder();
        }

        public Builder withAcceptors(Integer acceptors) {
            this.acceptors = acceptors;
            return this;
        }

        public Builder withAcceptQueueSize(Integer acceptQueueSize) {
            this.acceptQueueSize = acceptQueueSize;
            return this;
        }

        public Builder withRequestHeaderSize(Integer requestHeaderSize) {
            this.requestHeaderSize = requestHeaderSize;
            return this;
        }

        public Builder withResponseHeaderSize(Integer responseHeaderSize) {
            this.responseHeaderSize = responseHeaderSize;
            return this;
        }

        public Builder withStopTimeout(Long stopTimeout) {
            this.stopTimeout = stopTimeout;
            return this;
        }

        public Builder withIdleTimeout(Long idleTimeout) {
            this.idleTimeout = idleTimeout;
            return this;
        }

        public Builder withShutodwnIdleTimeout(Long shutdownIdleTimeout) {
            this.shutdownIdleTimeout = shutdownIdleTimeout;
            return this;
        }

        public JettySettings build() {
            return new JettySettings(Optional.ofNullable(this.acceptors), Optional.ofNullable(this.acceptQueueSize), Optional.ofNullable(this.requestHeaderSize), Optional.ofNullable(this.responseHeaderSize), Optional.ofNullable(this.stopTimeout), Optional.ofNullable(this.idleTimeout), Optional.ofNullable(this.shutdownIdleTimeout));
        }
    }
}

