/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating;

import com.github.tomakehurst.wiremock.common.ListOrSingle;
import com.github.tomakehurst.wiremock.common.url.PathTemplate;
import com.github.tomakehurst.wiremock.extension.responsetemplating.RequestLine;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.TreeMap;

public class RequestTemplateModel {
    private final RequestLine requestLine;
    private final Map<String, ListOrSingle<String>> headers;
    private final Map<String, ListOrSingle<String>> cookies;
    private final String body;

    protected RequestTemplateModel(RequestLine requestLine, Map<String, ListOrSingle<String>> headers, Map<String, ListOrSingle<String>> cookies, String body) {
        this.requestLine = requestLine;
        this.headers = headers;
        this.cookies = cookies;
        this.body = body;
    }

    public static RequestTemplateModel from(Request request) {
        return RequestTemplateModel.from(request, null);
    }

    public static RequestTemplateModel from(final Request request, PathTemplate pathTemplate) {
        RequestLine requestLine = RequestLine.fromRequest(request, pathTemplate);
        TreeMap<String, ListOrSingle<String>> adaptedHeaders = new TreeMap<String, ListOrSingle<String>>(String.CASE_INSENSITIVE_ORDER);
        adaptedHeaders.putAll((Map<String, ListOrSingle<String>>)Maps.toMap(request.getAllHeaderKeys(), (Function)new Function<String, ListOrSingle<String>>(){

            public ListOrSingle<String> apply(String input) {
                return ListOrSingle.of(request.header(input).values());
            }
        }));
        Map adaptedCookies = Maps.transformValues(request.getCookies(), (Function)new Function<Cookie, ListOrSingle<String>>(){

            public ListOrSingle<String> apply(Cookie cookie) {
                return ListOrSingle.of(cookie.getValues());
            }
        });
        return new RequestTemplateModel(requestLine, adaptedHeaders, adaptedCookies, request.getBodyAsString());
    }

    public RequestLine getRequestLine() {
        return this.requestLine;
    }

    public RequestMethod getMethod() {
        return this.requestLine.getMethod();
    }

    public Object getPathSegments() {
        return this.requestLine.getPathSegments();
    }

    public Object getPath() {
        return this.requestLine.getPathSegments();
    }

    public String getUrl() {
        return this.requestLine.getUrl();
    }

    public Map<String, ListOrSingle<String>> getQuery() {
        return this.requestLine.getQuery();
    }

    public String getScheme() {
        return this.requestLine.getScheme();
    }

    public String getHost() {
        return this.requestLine.getHost();
    }

    public int getPort() {
        return this.requestLine.getPort();
    }

    public String getBaseUrl() {
        return this.requestLine.getBaseUrl();
    }

    public Map<String, ListOrSingle<String>> getHeaders() {
        return this.headers;
    }

    public Map<String, ListOrSingle<String>> getCookies() {
        return this.cookies;
    }

    public String getBody() {
        return this.body;
    }

    public String getClientIp() {
        return this.requestLine.getClientIp();
    }
}

