/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class LogicalAnd
extends StringValuePattern {
    private final List<StringValuePattern> operands;

    public LogicalAnd(StringValuePattern ... operands) {
        this(Arrays.asList(operands));
    }

    public LogicalAnd(@JsonProperty(value="and") List<StringValuePattern> operands) {
        super(operands.stream().findFirst().map(ContentPattern::getValue).orElseThrow(() -> new IllegalArgumentException("Logical AND must be constructed with at least two matchers")));
        this.operands = operands;
    }

    @Override
    public String getExpected() {
        return this.operands.stream().map(contentPattern -> contentPattern.getName() + " " + contentPattern.getExpected()).collect(Collectors.joining(" AND "));
    }

    public List<StringValuePattern> getAnd() {
        return this.operands;
    }

    @Override
    public MatchResult match(String value) {
        return MatchResult.aggregate(this.operands.stream().map(matcher -> matcher.match(value)).collect(Collectors.toList()));
    }
}

