/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.core;

import com.github.tomakehurst.wiremock.admin.AdminRoutes;
import com.github.tomakehurst.wiremock.admin.LimitAndOffsetPaginator;
import com.github.tomakehurst.wiremock.admin.model.GetGlobalSettingsResult;
import com.github.tomakehurst.wiremock.admin.model.GetScenariosResult;
import com.github.tomakehurst.wiremock.admin.model.GetServeEventsResult;
import com.github.tomakehurst.wiremock.admin.model.ListStubMappingsResult;
import com.github.tomakehurst.wiremock.admin.model.ServeEventQuery;
import com.github.tomakehurst.wiremock.admin.model.SingleServedStubResult;
import com.github.tomakehurst.wiremock.admin.model.SingleStubMappingResult;
import com.github.tomakehurst.wiremock.common.BrowserProxySettings;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.xml.Xml;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.core.Container;
import com.github.tomakehurst.wiremock.core.MappingsSaver;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.StubServer;
import com.github.tomakehurst.wiremock.extension.AdminApiExtension;
import com.github.tomakehurst.wiremock.extension.GlobalSettingsListener;
import com.github.tomakehurst.wiremock.extension.PostServeAction;
import com.github.tomakehurst.wiremock.extension.ResponseDefinitionTransformer;
import com.github.tomakehurst.wiremock.extension.ResponseTransformer;
import com.github.tomakehurst.wiremock.extension.StubLifecycleListener;
import com.github.tomakehurst.wiremock.extension.requestfilter.RequestFilter;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.BasicResponseRenderer;
import com.github.tomakehurst.wiremock.http.ProxyResponseRenderer;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.http.StubResponseRenderer;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.recording.RecordSpec;
import com.github.tomakehurst.wiremock.recording.RecordSpecBuilder;
import com.github.tomakehurst.wiremock.recording.Recorder;
import com.github.tomakehurst.wiremock.recording.RecordingStatusResult;
import com.github.tomakehurst.wiremock.recording.SnapshotRecordResult;
import com.github.tomakehurst.wiremock.standalone.MappingsLoader;
import com.github.tomakehurst.wiremock.store.DefaultStores;
import com.github.tomakehurst.wiremock.store.SettingsStore;
import com.github.tomakehurst.wiremock.store.Stores;
import com.github.tomakehurst.wiremock.stubbing.InMemoryScenarios;
import com.github.tomakehurst.wiremock.stubbing.Scenarios;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.StoreBackedStubMappings;
import com.github.tomakehurst.wiremock.stubbing.StubImport;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.stubbing.StubMappings;
import com.github.tomakehurst.wiremock.verification.DisabledRequestJournal;
import com.github.tomakehurst.wiremock.verification.FindNearMissesResult;
import com.github.tomakehurst.wiremock.verification.FindRequestsResult;
import com.github.tomakehurst.wiremock.verification.FindServeEventsResult;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.NearMiss;
import com.github.tomakehurst.wiremock.verification.NearMissCalculator;
import com.github.tomakehurst.wiremock.verification.RequestJournal;
import com.github.tomakehurst.wiremock.verification.RequestJournalDisabledException;
import com.github.tomakehurst.wiremock.verification.StoreBackedRequestJournal;
import com.github.tomakehurst.wiremock.verification.VerificationResult;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class WireMockApp
implements StubServer,
Admin {
    public static final String FILES_ROOT = "__files";
    public static final String ADMIN_CONTEXT_ROOT = "/__admin";
    public static final String MAPPINGS_ROOT = "mappings";
    private static final MutableBoolean FACTORIES_LOADING_OPTIMIZED = new MutableBoolean(false);
    private final Stores stores;
    private final Scenarios scenarios;
    private final StubMappings stubMappings;
    private final RequestJournal requestJournal;
    private final SettingsStore settingsStore;
    private final boolean browserProxyingEnabled;
    private final MappingsLoader defaultMappingsLoader;
    private final Container container;
    private final MappingsSaver mappingsSaver;
    private final NearMissCalculator nearMissCalculator;
    private final Recorder recorder;
    private final List<GlobalSettingsListener> globalSettingsListeners;
    private Options options;

    public WireMockApp(Options options, Container container) {
        if (!options.getDisableOptimizeXmlFactoriesLoading() && FACTORIES_LOADING_OPTIMIZED.isFalse()) {
            Xml.optimizeFactoriesLoading();
            FACTORIES_LOADING_OPTIMIZED.setTrue();
        }
        this.options = options;
        this.stores = options.getStores();
        this.stores.start();
        this.browserProxyingEnabled = options.browserProxySettings().enabled();
        this.defaultMappingsLoader = options.mappingsLoader();
        this.mappingsSaver = options.mappingsSaver();
        this.settingsStore = this.stores.getSettingsStore();
        Map<String, RequestMatcherExtension> customMatchers = options.extensionsOfType(RequestMatcherExtension.class);
        this.requestJournal = options.requestJournalDisabled() ? new DisabledRequestJournal() : new StoreBackedRequestJournal(options.maxRequestJournalEntries().orElse(null), customMatchers, this.stores.getRequestJournalStore());
        this.scenarios = new InMemoryScenarios(this.stores.getScenariosStore());
        this.stubMappings = new StoreBackedStubMappings(this.stores.getStubStore(), this.scenarios, customMatchers, options.extensionsOfType(ResponseDefinitionTransformer.class), this.stores.getFilesBlobStore(), (List<StubLifecycleListener>)ImmutableList.copyOf(options.extensionsOfType(StubLifecycleListener.class).values()));
        this.nearMissCalculator = new NearMissCalculator(this.stubMappings, this.requestJournal, this.scenarios);
        this.recorder = new Recorder(this, this.stores.getRecorderStateStore());
        this.globalSettingsListeners = ImmutableList.copyOf(options.extensionsOfType(GlobalSettingsListener.class).values());
        this.container = container;
        this.loadDefaultMappings();
    }

    public WireMockApp(boolean browserProxyingEnabled, MappingsLoader defaultMappingsLoader, MappingsSaver mappingsSaver, boolean requestJournalDisabled, Integer maxRequestJournalEntries, Map<String, ResponseDefinitionTransformer> transformers, Map<String, RequestMatcherExtension> requestMatchers, FileSource rootFileSource, Container container) {
        this.stores = new DefaultStores(rootFileSource);
        this.browserProxyingEnabled = browserProxyingEnabled;
        this.defaultMappingsLoader = defaultMappingsLoader;
        this.mappingsSaver = mappingsSaver;
        this.settingsStore = this.stores.getSettingsStore();
        this.requestJournal = requestJournalDisabled ? new DisabledRequestJournal() : new StoreBackedRequestJournal(maxRequestJournalEntries, requestMatchers, this.stores.getRequestJournalStore());
        this.scenarios = new InMemoryScenarios(this.stores.getScenariosStore());
        this.stubMappings = new StoreBackedStubMappings(this.stores.getStubStore(), this.scenarios, requestMatchers, transformers, this.stores.getFilesBlobStore(), Collections.emptyList());
        this.container = container;
        this.nearMissCalculator = new NearMissCalculator(this.stubMappings, this.requestJournal, this.scenarios);
        this.recorder = new Recorder(this, this.stores.getRecorderStateStore());
        this.globalSettingsListeners = Collections.emptyList();
        this.loadDefaultMappings();
    }

    public AdminRequestHandler buildAdminRequestHandler() {
        AdminRoutes adminRoutes = AdminRoutes.forServer(this.options.extensionsOfType(AdminApiExtension.class).values(), this.options.getNotMatchedRenderer(), this.stores);
        return new AdminRequestHandler(adminRoutes, this, new BasicResponseRenderer(), this.options.getAdminAuthenticator(), this.options.getHttpsRequiredForAdminApi(), this.getAdminRequestFilters(), this.options.getDataTruncationSettings());
    }

    public StubRequestHandler buildStubRequestHandler() {
        Map<String, PostServeAction> postServeActions = this.options.extensionsOfType(PostServeAction.class);
        BrowserProxySettings browserProxySettings = this.options.browserProxySettings();
        return new StubRequestHandler(this, new StubResponseRenderer(this.options.getStores().getFilesBlobStore(), this.settingsStore, new ProxyResponseRenderer(this.options.proxyVia(), this.options.httpsSettings().trustStore(), this.options.shouldPreserveHostHeader(), this.options.proxyHostHeader(), this.settingsStore, browserProxySettings.trustAllProxyTargets(), browserProxySettings.trustedProxyTargets(), this.options.getStubCorsEnabled(), this.options.getProxyTargetRules(), this.options.proxyTimeout()), (List<ResponseTransformer>)ImmutableList.copyOf(this.options.extensionsOfType(ResponseTransformer.class).values())), this, postServeActions, this.requestJournal, this.getStubRequestFilters(), this.options.getStubRequestLoggingDisabled(), this.options.getDataTruncationSettings());
    }

    private List<RequestFilter> getAdminRequestFilters() {
        return this.options.extensionsOfType(RequestFilter.class).values().stream().filter(RequestFilter::applyToAdmin).collect(Collectors.toList());
    }

    private List<RequestFilter> getStubRequestFilters() {
        return this.options.extensionsOfType(RequestFilter.class).values().stream().filter(RequestFilter::applyToStubs).collect(Collectors.toList());
    }

    private void loadDefaultMappings() {
        this.loadMappingsUsing(this.defaultMappingsLoader);
    }

    public void loadMappingsUsing(MappingsLoader mappingsLoader) {
        mappingsLoader.loadMappingsInto(this.stubMappings);
    }

    @Override
    public ServeEvent serveStubFor(Request request) {
        ServeEvent serveEvent = this.stubMappings.serveFor(request);
        if (serveEvent.isNoExactMatch() && this.browserProxyingEnabled && request.isBrowserProxyRequest() && this.getGlobalSettings().getSettings().getProxyPassThrough()) {
            return ServeEvent.of(serveEvent.getRequest(), ResponseDefinition.browserProxy(request));
        }
        return serveEvent;
    }

    @Override
    public void addStubMapping(StubMapping stubMapping) {
        if (stubMapping.getId() == null) {
            stubMapping.setId(UUID.randomUUID());
        }
        this.stubMappings.addMapping(stubMapping);
        if (stubMapping.shouldBePersisted()) {
            this.mappingsSaver.save(stubMapping);
        }
    }

    @Override
    public void removeStubMapping(StubMapping stubMapping) {
        this.stubMappings.get(stubMapping.getId()).ifPresent(stubToDelete -> {
            if (stubToDelete.shouldBePersisted()) {
                this.mappingsSaver.remove((StubMapping)stubToDelete);
            }
        });
        this.stubMappings.removeMapping(stubMapping);
    }

    @Override
    public void removeStubMapping(UUID id) {
        this.stubMappings.get(id).ifPresent(this::removeStubMapping);
    }

    @Override
    public void editStubMapping(StubMapping stubMapping) {
        this.stubMappings.editMapping(stubMapping);
        if (stubMapping.shouldBePersisted()) {
            this.mappingsSaver.save(stubMapping);
        }
    }

    @Override
    public ListStubMappingsResult listAllStubMappings() {
        return new ListStubMappingsResult(LimitAndOffsetPaginator.none(this.stubMappings.getAll()));
    }

    @Override
    public SingleStubMappingResult getStubMapping(UUID id) {
        return SingleStubMappingResult.fromOptional(this.stubMappings.get(id));
    }

    @Override
    public void saveMappings() {
        for (StubMapping stubMapping : this.stubMappings.getAll()) {
            stubMapping.setPersistent(true);
            this.stubMappings.editMapping(stubMapping);
        }
        this.mappingsSaver.save(this.stubMappings.getAll());
    }

    @Override
    public void resetAll() {
        this.resetToDefaultMappings();
    }

    @Override
    public void resetRequests() {
        this.requestJournal.reset();
    }

    @Override
    public void resetToDefaultMappings() {
        this.stubMappings.reset();
        this.resetRequests();
        this.loadDefaultMappings();
    }

    @Override
    public void resetScenarios() {
        this.stubMappings.resetScenarios();
    }

    @Override
    public void resetMappings() {
        this.mappingsSaver.removeAll();
        this.stubMappings.reset();
    }

    @Override
    public GetServeEventsResult getServeEvents() {
        return this.getServeEvents(ServeEventQuery.ALL);
    }

    @Override
    public GetServeEventsResult getServeEvents(ServeEventQuery query) {
        try {
            List<ServeEvent> serveEvents = query.filter(this.requestJournal.getAllServeEvents());
            return GetServeEventsResult.requestJournalEnabled(LimitAndOffsetPaginator.none(serveEvents));
        }
        catch (RequestJournalDisabledException e) {
            return GetServeEventsResult.requestJournalDisabled(LimitAndOffsetPaginator.none(this.requestJournal.getAllServeEvents()));
        }
    }

    @Override
    public SingleServedStubResult getServedStub(UUID id) {
        return SingleServedStubResult.fromOptional(this.requestJournal.getServeEvent(id));
    }

    @Override
    public VerificationResult countRequestsMatching(RequestPattern requestPattern) {
        try {
            return VerificationResult.withCount(this.requestJournal.countRequestsMatching(requestPattern));
        }
        catch (RequestJournalDisabledException e) {
            return VerificationResult.withRequestJournalDisabled();
        }
    }

    @Override
    public FindRequestsResult findRequestsMatching(RequestPattern requestPattern) {
        try {
            List<LoggedRequest> requests = this.requestJournal.getRequestsMatching(requestPattern);
            return FindRequestsResult.withRequests(requests);
        }
        catch (RequestJournalDisabledException e) {
            return FindRequestsResult.withRequestJournalDisabled();
        }
    }

    @Override
    public FindRequestsResult findUnmatchedRequests() {
        try {
            List<LoggedRequest> requests = this.requestJournal.getAllServeEvents().stream().filter(ServeEvent.NOT_MATCHED).map(ServeEvent.TO_LOGGED_REQUEST).collect(Collectors.toList());
            return FindRequestsResult.withRequests(requests);
        }
        catch (RequestJournalDisabledException e) {
            return FindRequestsResult.withRequestJournalDisabled();
        }
    }

    @Override
    public void removeServeEvent(UUID eventId) {
        this.requestJournal.removeEvent(eventId);
    }

    @Override
    public FindServeEventsResult removeServeEventsMatching(RequestPattern requestPattern) {
        return new FindServeEventsResult(this.requestJournal.removeEventsMatching(requestPattern));
    }

    @Override
    public FindServeEventsResult removeServeEventsForStubsMatchingMetadata(StringValuePattern metadataPattern) {
        return new FindServeEventsResult(this.requestJournal.removeServeEventsForStubsMatchingMetadata(metadataPattern));
    }

    @Override
    public FindNearMissesResult findNearMissesForUnmatchedRequests() {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        List unmatchedServeEvents = this.requestJournal.getAllServeEvents().stream().filter(ServeEvent::isNoExactMatch).collect(Collectors.toList());
        for (ServeEvent serveEvent : unmatchedServeEvents) {
            listBuilder.addAll(this.nearMissCalculator.findNearestTo(serveEvent.getRequest()));
        }
        return new FindNearMissesResult((List<NearMiss>)listBuilder.build());
    }

    @Override
    public GetScenariosResult getAllScenarios() {
        return new GetScenariosResult(this.stubMappings.getAllScenarios());
    }

    @Override
    public void resetScenario(String name) {
        this.scenarios.resetSingle(name);
    }

    @Override
    public void setScenarioState(String name, String state) {
        this.scenarios.setSingle(name, state);
    }

    @Override
    public FindNearMissesResult findTopNearMissesFor(LoggedRequest loggedRequest) {
        return new FindNearMissesResult(this.nearMissCalculator.findNearestTo(loggedRequest));
    }

    @Override
    public FindNearMissesResult findTopNearMissesFor(RequestPattern requestPattern) {
        return new FindNearMissesResult(this.nearMissCalculator.findNearestTo(requestPattern));
    }

    @Override
    public GetGlobalSettingsResult getGlobalSettings() {
        return new GetGlobalSettingsResult(this.settingsStore.get());
    }

    @Override
    public void updateGlobalSettings(GlobalSettings newSettings) {
        GlobalSettings oldSettings = this.settingsStore.get();
        for (GlobalSettingsListener listener : this.globalSettingsListeners) {
            listener.beforeGlobalSettingsUpdated(oldSettings, newSettings);
        }
        this.settingsStore.set(newSettings);
        for (GlobalSettingsListener listener : this.globalSettingsListeners) {
            listener.afterGlobalSettingsUpdated(oldSettings, newSettings);
        }
    }

    public int port() {
        return this.container.port();
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public void shutdownServer() {
        this.stores.stop();
        this.container.shutdown();
    }

    @Override
    public SnapshotRecordResult snapshotRecord() {
        return this.snapshotRecord(RecordSpec.DEFAULTS);
    }

    @Override
    public SnapshotRecordResult snapshotRecord(RecordSpecBuilder spec) {
        return this.snapshotRecord(spec.build());
    }

    @Override
    public SnapshotRecordResult snapshotRecord(RecordSpec recordSpec) {
        return this.recorder.takeSnapshot(this.getServeEvents().getServeEvents(), recordSpec);
    }

    @Override
    public void startRecording(String targetBaseUrl) {
        this.recorder.startRecording(RecordSpec.forBaseUrl(targetBaseUrl));
    }

    @Override
    public void startRecording(RecordSpec recordSpec) {
        this.recorder.startRecording(recordSpec);
    }

    @Override
    public void startRecording(RecordSpecBuilder recordSpec) {
        this.recorder.startRecording(recordSpec.build());
    }

    @Override
    public SnapshotRecordResult stopRecording() {
        return this.recorder.stopRecording();
    }

    @Override
    public RecordingStatusResult getRecordingStatus() {
        return new RecordingStatusResult(this.recorder.getStatus().name());
    }

    @Override
    public ListStubMappingsResult findAllStubsByMetadata(StringValuePattern pattern) {
        return new ListStubMappingsResult(LimitAndOffsetPaginator.none(this.stubMappings.findByMetadata(pattern)));
    }

    @Override
    public void removeStubsByMetadata(StringValuePattern pattern) {
        List<StubMapping> foundMappings = this.stubMappings.findByMetadata(pattern);
        for (StubMapping mapping : foundMappings) {
            this.removeStubMapping(mapping);
        }
    }

    @Override
    public void importStubs(StubImport stubImport) {
        List<StubMapping> mappings = stubImport.getMappings();
        StubImport.Options importOptions = (StubImport.Options)MoreObjects.firstNonNull((Object)stubImport.getImportOptions(), (Object)StubImport.Options.DEFAULTS);
        for (int i = mappings.size() - 1; i >= 0; --i) {
            StubMapping mapping = mappings.get(i);
            if (mapping.getId() != null && this.getStubMapping(mapping.getId()).isPresent()) {
                if (importOptions.getDuplicatePolicy() != StubImport.Options.DuplicatePolicy.OVERWRITE) continue;
                this.editStubMapping(mapping);
                continue;
            }
            this.addStubMapping(mapping);
        }
        if (importOptions.getDeleteAllNotInImport().booleanValue()) {
            Iterable ids = mappings.stream().map(StubMapping::getId).collect(Collectors.toList());
            for (StubMapping mapping : this.listAllStubMappings().getMappings()) {
                if (Iterables.contains((Iterable)ids, (Object)mapping.getId())) continue;
                this.removeStubMapping(mapping);
            }
        }
    }
}

