/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.client;

import com.github.tomakehurst.wiremock.admin.model.ListStubMappingsResult;
import com.github.tomakehurst.wiremock.admin.model.SingleStubMappingResult;
import com.github.tomakehurst.wiremock.client.BasicMappingBuilder;
import com.github.tomakehurst.wiremock.client.CountMatchingStrategy;
import com.github.tomakehurst.wiremock.client.HttpAdminClient;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.VerificationException;
import com.github.tomakehurst.wiremock.common.SingleRootFileSource;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.extension.Parameters;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.github.tomakehurst.wiremock.global.GlobalSettingsHolder;
import com.github.tomakehurst.wiremock.http.DelayDistribution;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.AnythingPattern;
import com.github.tomakehurst.wiremock.matching.BinaryEqualToPattern;
import com.github.tomakehurst.wiremock.matching.ContainsPattern;
import com.github.tomakehurst.wiremock.matching.EqualToJsonPattern;
import com.github.tomakehurst.wiremock.matching.EqualToPattern;
import com.github.tomakehurst.wiremock.matching.EqualToXmlPattern;
import com.github.tomakehurst.wiremock.matching.MatchesJsonPathPattern;
import com.github.tomakehurst.wiremock.matching.MatchesXPathPattern;
import com.github.tomakehurst.wiremock.matching.NegativeRegexPattern;
import com.github.tomakehurst.wiremock.matching.RegexPattern;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPathPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.github.tomakehurst.wiremock.matching.ValueMatcher;
import com.github.tomakehurst.wiremock.recording.RecordSpecBuilder;
import com.github.tomakehurst.wiremock.recording.RecordingStatusResult;
import com.github.tomakehurst.wiremock.recording.SnapshotRecordResult;
import com.github.tomakehurst.wiremock.standalone.RemoteMappingsLoader;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.verification.Diff;
import com.github.tomakehurst.wiremock.verification.FindNearMissesResult;
import com.github.tomakehurst.wiremock.verification.FindRequestsResult;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.NearMiss;
import com.github.tomakehurst.wiremock.verification.VerificationResult;
import com.google.common.collect.FluentIterable;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class WireMock {
    private static final int DEFAULT_PORT = 8080;
    private static final String DEFAULT_HOST = "localhost";
    private final Admin admin;
    private final GlobalSettingsHolder globalSettingsHolder = new GlobalSettingsHolder();
    private static ThreadLocal<WireMock> defaultInstance = new ThreadLocal<WireMock>(){

        @Override
        protected WireMock initialValue() {
            return new WireMock();
        }
    };

    public WireMock(Admin admin) {
        this.admin = admin;
    }

    public WireMock(int port) {
        this(DEFAULT_HOST, port);
    }

    public WireMock(String host, int port) {
        this.admin = new HttpAdminClient(host, port);
    }

    public WireMock(String host, int port, String urlPathPrefix) {
        this.admin = new HttpAdminClient(host, port, urlPathPrefix);
    }

    public WireMock(String scheme, String host, int port) {
        this.admin = new HttpAdminClient(scheme, host, port);
    }

    public WireMock(String scheme, String host, int port, String urlPathPrefix) {
        this.admin = new HttpAdminClient(scheme, host, port, urlPathPrefix);
    }

    public WireMock(String scheme, String host, int port, String urlPathPrefix, String hostHeader, String proxyHost, int proxyPort) {
        this.admin = new HttpAdminClient(scheme, host, port, urlPathPrefix, hostHeader, proxyHost, proxyPort);
    }

    public WireMock() {
        this.admin = new HttpAdminClient(DEFAULT_HOST, 8080);
    }

    public static StubMapping givenThat(MappingBuilder mappingBuilder) {
        return defaultInstance.get().register(mappingBuilder);
    }

    public static StubMapping stubFor(MappingBuilder mappingBuilder) {
        return WireMock.givenThat(mappingBuilder);
    }

    public static void editStub(MappingBuilder mappingBuilder) {
        defaultInstance.get().editStubMapping(mappingBuilder);
    }

    public static void removeStub(MappingBuilder mappingBuilder) {
        defaultInstance.get().removeStubMapping(mappingBuilder);
    }

    public static void removeStub(StubMapping stubMapping) {
        defaultInstance.get().removeStubMapping(stubMapping);
    }

    public static ListStubMappingsResult listAllStubMappings() {
        return defaultInstance.get().allStubMappings();
    }

    public static StubMapping getSingleStubMapping(UUID id) {
        return (StubMapping)defaultInstance.get().getStubMapping(id).getItem();
    }

    public static void configureFor(int port) {
        defaultInstance.set(new WireMock(port));
    }

    public static void configureFor(String host, int port) {
        defaultInstance.set(new WireMock(host, port));
    }

    public static void configureFor(String host, int port, String urlPathPrefix) {
        defaultInstance.set(new WireMock(host, port, urlPathPrefix));
    }

    public static void configureFor(String scheme, String host, int port, String urlPathPrefix) {
        defaultInstance.set(new WireMock(scheme, host, port, urlPathPrefix));
    }

    public static void configureFor(String scheme, String host, int port) {
        defaultInstance.set(new WireMock(scheme, host, port));
    }

    public static void configureFor(String scheme, String host, int port, String proxyHost, int proxyPort) {
        defaultInstance.set(new WireMock(scheme, host, port, "", null, proxyHost, proxyPort));
    }

    public static void configure() {
        defaultInstance.set(new WireMock());
    }

    public static StringValuePattern equalTo(String value) {
        return new EqualToPattern(value);
    }

    public static BinaryEqualToPattern binaryEqualTo(byte[] content) {
        return new BinaryEqualToPattern(content);
    }

    public static BinaryEqualToPattern binaryEqualTo(String content) {
        return new BinaryEqualToPattern(content);
    }

    public static StringValuePattern equalToIgnoreCase(String value) {
        return new EqualToPattern(value, true);
    }

    public static StringValuePattern equalToJson(String value) {
        return new EqualToJsonPattern(value, null, null);
    }

    public static StringValuePattern equalToJson(String value, boolean ignoreArrayOrder, boolean ignoreExtraElements) {
        return new EqualToJsonPattern(value, ignoreArrayOrder, ignoreExtraElements);
    }

    public static StringValuePattern matchingJsonPath(String value) {
        return new MatchesJsonPathPattern(value);
    }

    public static StringValuePattern matchingJsonPath(String value, StringValuePattern valuePattern) {
        return new MatchesJsonPathPattern(value, valuePattern);
    }

    public static StringValuePattern equalToXml(String value) {
        return new EqualToXmlPattern(value);
    }

    public static MatchesXPathPattern matchingXPath(String value) {
        return new MatchesXPathPattern(value, Collections.emptyMap());
    }

    public static StringValuePattern matchingXPath(String value, Map<String, String> namespaces) {
        return new MatchesXPathPattern(value, namespaces);
    }

    public static StringValuePattern matchingXPath(String value, StringValuePattern valuePattern) {
        return new MatchesXPathPattern(value, valuePattern);
    }

    public static StringValuePattern containing(String value) {
        return new ContainsPattern(value);
    }

    public static StringValuePattern matching(String regex) {
        return new RegexPattern(regex);
    }

    public static StringValuePattern notMatching(String regex) {
        return new NegativeRegexPattern(regex);
    }

    public static StringValuePattern absent() {
        return StringValuePattern.ABSENT;
    }

    public void saveMappings() {
        this.admin.saveMappings();
    }

    public static void saveAllMappings() {
        defaultInstance.get().saveMappings();
    }

    public void removeMappings() {
        this.admin.resetMappings();
    }

    public static void removeAllMappings() {
        defaultInstance.get().removeMappings();
    }

    public void resetMappings() {
        this.admin.resetAll();
    }

    public static void reset() {
        defaultInstance.get().resetMappings();
    }

    public static void resetAllRequests() {
        defaultInstance.get().resetRequests();
    }

    public void resetRequests() {
        this.admin.resetRequests();
    }

    public void resetScenarios() {
        this.admin.resetScenarios();
    }

    public static void resetAllScenarios() {
        defaultInstance.get().resetScenarios();
    }

    public void resetToDefaultMappings() {
        this.admin.resetToDefaultMappings();
    }

    public static void resetToDefault() {
        defaultInstance.get().resetToDefaultMappings();
    }

    public StubMapping register(MappingBuilder mappingBuilder) {
        StubMapping mapping = mappingBuilder.build();
        this.register(mapping);
        return mapping;
    }

    public void register(StubMapping mapping) {
        this.admin.addStubMapping(mapping);
    }

    public void editStubMapping(MappingBuilder mappingBuilder) {
        this.admin.editStubMapping(mappingBuilder.build());
    }

    public void removeStubMapping(MappingBuilder mappingBuilder) {
        this.admin.removeStubMapping(mappingBuilder.build());
    }

    public void removeStubMapping(StubMapping stubMapping) {
        this.admin.removeStubMapping(stubMapping);
    }

    public ListStubMappingsResult allStubMappings() {
        return this.admin.listAllStubMappings();
    }

    public SingleStubMappingResult getStubMapping(UUID id) {
        return this.admin.getStubMapping(id);
    }

    public static UrlPattern urlEqualTo(String testUrl) {
        return new UrlPattern(WireMock.equalTo(testUrl), false);
    }

    public static UrlPattern urlMatching(String urlRegex) {
        return new UrlPattern(WireMock.matching(urlRegex), true);
    }

    public static UrlPathPattern urlPathEqualTo(String testUrl) {
        return new UrlPathPattern(WireMock.equalTo(testUrl), false);
    }

    public static UrlPathPattern urlPathMatching(String urlRegex) {
        return new UrlPathPattern(WireMock.matching(urlRegex), true);
    }

    public static UrlPattern anyUrl() {
        return new UrlPattern(new AnythingPattern(), false);
    }

    public static CountMatchingStrategy lessThan(int expected) {
        return new CountMatchingStrategy(CountMatchingStrategy.LESS_THAN, expected);
    }

    public static CountMatchingStrategy lessThanOrExactly(int expected) {
        return new CountMatchingStrategy(CountMatchingStrategy.LESS_THAN_OR_EQUAL, expected);
    }

    public static CountMatchingStrategy exactly(int expected) {
        return new CountMatchingStrategy(CountMatchingStrategy.EQUAL_TO, expected);
    }

    public static CountMatchingStrategy moreThanOrExactly(int expected) {
        return new CountMatchingStrategy(CountMatchingStrategy.GREATER_THAN_OR_EQUAL, expected);
    }

    public static CountMatchingStrategy moreThan(int expected) {
        return new CountMatchingStrategy(CountMatchingStrategy.GREATER_THAN, expected);
    }

    public static MappingBuilder get(UrlPattern urlPattern) {
        return new BasicMappingBuilder(RequestMethod.GET, urlPattern);
    }

    public static MappingBuilder post(UrlPattern urlPattern) {
        return new BasicMappingBuilder(RequestMethod.POST, urlPattern);
    }

    public static MappingBuilder put(UrlPattern urlPattern) {
        return new BasicMappingBuilder(RequestMethod.PUT, urlPattern);
    }

    public static MappingBuilder delete(UrlPattern urlPattern) {
        return new BasicMappingBuilder(RequestMethod.DELETE, urlPattern);
    }

    public static MappingBuilder patch(UrlPattern urlPattern) {
        return new BasicMappingBuilder(RequestMethod.PATCH, urlPattern);
    }

    public static MappingBuilder head(UrlPattern urlPattern) {
        return new BasicMappingBuilder(RequestMethod.HEAD, urlPattern);
    }

    public static MappingBuilder options(UrlPattern urlPattern) {
        return new BasicMappingBuilder(RequestMethod.OPTIONS, urlPattern);
    }

    public static MappingBuilder trace(UrlPattern urlPattern) {
        return new BasicMappingBuilder(RequestMethod.TRACE, urlPattern);
    }

    public static MappingBuilder any(UrlPattern urlPattern) {
        return new BasicMappingBuilder(RequestMethod.ANY, urlPattern);
    }

    public static MappingBuilder request(String method, UrlPattern urlPattern) {
        return new BasicMappingBuilder(RequestMethod.fromString(method), urlPattern);
    }

    public static MappingBuilder requestMatching(String customRequestMatcherName) {
        return new BasicMappingBuilder(customRequestMatcherName, Parameters.empty());
    }

    public static MappingBuilder requestMatching(String customRequestMatcherName, Parameters parameters) {
        return new BasicMappingBuilder(customRequestMatcherName, parameters);
    }

    public static MappingBuilder requestMatching(ValueMatcher<Request> requestMatcher) {
        return new BasicMappingBuilder(requestMatcher);
    }

    public static ResponseDefinitionBuilder aResponse() {
        return new ResponseDefinitionBuilder();
    }

    public static ResponseDefinitionBuilder ok() {
        return WireMock.aResponse().withStatus(200);
    }

    public static ResponseDefinitionBuilder ok(String body) {
        return WireMock.aResponse().withStatus(200).withBody(body);
    }

    public static ResponseDefinitionBuilder okForContentType(String contentType, String body) {
        return WireMock.aResponse().withStatus(200).withHeader("Content-Type", contentType).withBody(body);
    }

    public static ResponseDefinitionBuilder okJson(String body) {
        return WireMock.okForContentType("application/json", body);
    }

    public static ResponseDefinitionBuilder okXml(String body) {
        return WireMock.okForContentType("application/xml", body);
    }

    public static ResponseDefinitionBuilder okTextXml(String body) {
        return WireMock.okForContentType("text/xml", body);
    }

    public static MappingBuilder proxyAllTo(String url) {
        return WireMock.any(WireMock.anyUrl()).willReturn(WireMock.aResponse().proxiedFrom(url));
    }

    public static MappingBuilder get(String url) {
        return WireMock.get(WireMock.urlEqualTo(url));
    }

    public static MappingBuilder post(String url) {
        return WireMock.post(WireMock.urlEqualTo(url));
    }

    public static MappingBuilder put(String url) {
        return WireMock.put(WireMock.urlEqualTo(url));
    }

    public static MappingBuilder delete(String url) {
        return WireMock.delete(WireMock.urlEqualTo(url));
    }

    public static ResponseDefinitionBuilder created() {
        return WireMock.aResponse().withStatus(201);
    }

    public static ResponseDefinitionBuilder noContent() {
        return WireMock.aResponse().withStatus(204);
    }

    public static ResponseDefinitionBuilder permanentRedirect(String location) {
        return WireMock.aResponse().withStatus(301).withHeader("Location", location);
    }

    public static ResponseDefinitionBuilder temporaryRedirect(String location) {
        return WireMock.aResponse().withStatus(302).withHeader("Location", location);
    }

    public static ResponseDefinitionBuilder seeOther(String location) {
        return WireMock.aResponse().withStatus(303).withHeader("Location", location);
    }

    public static ResponseDefinitionBuilder badRequest() {
        return WireMock.aResponse().withStatus(400);
    }

    public static ResponseDefinitionBuilder badRequestEntity() {
        return WireMock.aResponse().withStatus(422);
    }

    public static ResponseDefinitionBuilder unauthorized() {
        return WireMock.aResponse().withStatus(401);
    }

    public static ResponseDefinitionBuilder forbidden() {
        return WireMock.aResponse().withStatus(403);
    }

    public static ResponseDefinitionBuilder notFound() {
        return WireMock.aResponse().withStatus(404);
    }

    public static ResponseDefinitionBuilder serverError() {
        return WireMock.aResponse().withStatus(500);
    }

    public static ResponseDefinitionBuilder serviceUnavailable() {
        return WireMock.aResponse().withStatus(503);
    }

    public static ResponseDefinitionBuilder status(int status) {
        return WireMock.aResponse().withStatus(status);
    }

    public void verifyThat(RequestPatternBuilder requestPatternBuilder) {
        this.verifyThat(WireMock.moreThanOrExactly(1), requestPatternBuilder);
    }

    public void verifyThat(int expectedCount, RequestPatternBuilder requestPatternBuilder) {
        this.verifyThat(WireMock.exactly(expectedCount), requestPatternBuilder);
    }

    public void verifyThat(CountMatchingStrategy expectedCount, RequestPatternBuilder requestPatternBuilder) {
        int actualCount;
        RequestPattern requestPattern = requestPatternBuilder.build();
        if (requestPattern.hasCustomMatcher()) {
            List<LoggedRequest> requests = this.admin.findRequestsMatching(RequestPattern.everything()).getRequests();
            actualCount = FluentIterable.from(requests).filter(RequestPattern.thatMatch(requestPattern)).size();
        } else {
            VerificationResult result = this.admin.countRequestsMatching(requestPattern);
            result.assertRequestJournalEnabled();
            actualCount = result.getCount();
        }
        if (!expectedCount.match(actualCount)) {
            throw actualCount == 0 ? this.verificationExceptionForNearMisses(requestPatternBuilder, requestPattern) : new VerificationException(requestPattern, expectedCount, actualCount);
        }
    }

    private VerificationException verificationExceptionForNearMisses(RequestPatternBuilder requestPatternBuilder, RequestPattern requestPattern) {
        List<NearMiss> nearMisses = this.findAllNearMissesFor(requestPatternBuilder);
        if (nearMisses.size() > 0) {
            Diff diff = new Diff(requestPattern, nearMisses.get(0).getRequest());
            return VerificationException.forUnmatchedRequestPattern(diff);
        }
        return new VerificationException(requestPattern, this.find(RequestPatternBuilder.allRequests()));
    }

    public static void verify(RequestPatternBuilder requestPatternBuilder) {
        defaultInstance.get().verifyThat(requestPatternBuilder);
    }

    public static void verify(int count, RequestPatternBuilder requestPatternBuilder) {
        defaultInstance.get().verifyThat(count, requestPatternBuilder);
    }

    public static void verify(CountMatchingStrategy countMatchingStrategy, RequestPatternBuilder requestPatternBuilder) {
        defaultInstance.get().verifyThat(countMatchingStrategy, requestPatternBuilder);
    }

    public List<LoggedRequest> find(RequestPatternBuilder requestPatternBuilder) {
        FindRequestsResult result = this.admin.findRequestsMatching(requestPatternBuilder.build());
        result.assertRequestJournalEnabled();
        return result.getRequests();
    }

    public static List<LoggedRequest> findAll(RequestPatternBuilder requestPatternBuilder) {
        return defaultInstance.get().find(requestPatternBuilder);
    }

    public static List<ServeEvent> getAllServeEvents() {
        return defaultInstance.get().getServeEvents();
    }

    public List<ServeEvent> getServeEvents() {
        return this.admin.getServeEvents().getRequests();
    }

    public static RequestPatternBuilder getRequestedFor(UrlPattern urlPattern) {
        return new RequestPatternBuilder(RequestMethod.GET, urlPattern);
    }

    public static RequestPatternBuilder postRequestedFor(UrlPattern urlPattern) {
        return new RequestPatternBuilder(RequestMethod.POST, urlPattern);
    }

    public static RequestPatternBuilder putRequestedFor(UrlPattern urlPattern) {
        return new RequestPatternBuilder(RequestMethod.PUT, urlPattern);
    }

    public static RequestPatternBuilder deleteRequestedFor(UrlPattern urlPattern) {
        return new RequestPatternBuilder(RequestMethod.DELETE, urlPattern);
    }

    public static RequestPatternBuilder patchRequestedFor(UrlPattern urlPattern) {
        return new RequestPatternBuilder(RequestMethod.PATCH, urlPattern);
    }

    public static RequestPatternBuilder headRequestedFor(UrlPattern urlPattern) {
        return new RequestPatternBuilder(RequestMethod.HEAD, urlPattern);
    }

    public static RequestPatternBuilder optionsRequestedFor(UrlPattern urlPattern) {
        return new RequestPatternBuilder(RequestMethod.OPTIONS, urlPattern);
    }

    public static RequestPatternBuilder traceRequestedFor(UrlPattern urlPattern) {
        return new RequestPatternBuilder(RequestMethod.TRACE, urlPattern);
    }

    public static RequestPatternBuilder anyRequestedFor(UrlPattern urlPattern) {
        return new RequestPatternBuilder(RequestMethod.ANY, urlPattern);
    }

    public static RequestPatternBuilder requestMadeFor(String customMatcherName, Parameters parameters) {
        return RequestPatternBuilder.forCustomMatcher(customMatcherName, parameters);
    }

    public static RequestPatternBuilder requestMadeFor(ValueMatcher<Request> requestMatcher) {
        return RequestPatternBuilder.forCustomMatcher(requestMatcher);
    }

    public static void setGlobalFixedDelay(int milliseconds) {
        defaultInstance.get().setGlobalFixedDelayVariable(milliseconds);
    }

    public void setGlobalFixedDelayVariable(int milliseconds) {
        GlobalSettings settings = this.globalSettingsHolder.get().copy();
        settings.setFixedDelay(milliseconds);
        this.updateGlobalSettings(settings);
    }

    public static void setGlobalRandomDelay(DelayDistribution distribution) {
        defaultInstance.get().setGlobalRandomDelayVariable(distribution);
    }

    public void setGlobalRandomDelayVariable(DelayDistribution distribution) {
        GlobalSettings settings = this.globalSettingsHolder.get().copy();
        settings.setDelayDistribution(distribution);
        this.updateGlobalSettings(settings);
    }

    private void updateGlobalSettings(GlobalSettings settings) {
        this.globalSettingsHolder.replaceWith(settings);
        this.admin.updateGlobalSettings(settings);
    }

    public void shutdown() {
        this.admin.shutdownServer();
    }

    public static void shutdownServer() {
        defaultInstance.get().shutdown();
    }

    public static List<NearMiss> findNearMissesForAllUnmatched() {
        return defaultInstance.get().findNearMissesForAllUnmatchedRequests();
    }

    public List<NearMiss> findNearMissesForAllUnmatchedRequests() {
        FindNearMissesResult nearMissesResult = this.admin.findNearMissesForUnmatchedRequests();
        return nearMissesResult.getNearMisses();
    }

    public static List<LoggedRequest> findUnmatchedRequests() {
        return defaultInstance.get().findAllUnmatchedRequests();
    }

    public List<LoggedRequest> findAllUnmatchedRequests() {
        FindRequestsResult unmatchedResult = this.admin.findUnmatchedRequests();
        return unmatchedResult.getRequests();
    }

    public static List<NearMiss> findNearMissesFor(LoggedRequest loggedRequest) {
        return defaultInstance.get().findTopNearMissesFor(loggedRequest);
    }

    public List<NearMiss> findTopNearMissesFor(LoggedRequest loggedRequest) {
        FindNearMissesResult nearMissesResult = this.admin.findTopNearMissesFor(loggedRequest);
        return nearMissesResult.getNearMisses();
    }

    public static List<NearMiss> findNearMissesFor(RequestPatternBuilder requestPatternBuilder) {
        return defaultInstance.get().findAllNearMissesFor(requestPatternBuilder);
    }

    public List<NearMiss> findAllNearMissesFor(RequestPatternBuilder requestPatternBuilder) {
        FindNearMissesResult nearMissesResult = this.admin.findTopNearMissesFor(requestPatternBuilder.build());
        return nearMissesResult.getNearMisses();
    }

    public void loadMappingsFrom(String rootDir) {
        this.loadMappingsFrom(new File(rootDir));
    }

    public void loadMappingsFrom(File rootDir) {
        SingleRootFileSource mappingsSource = new SingleRootFileSource(rootDir);
        new RemoteMappingsLoader(mappingsSource, this).load();
    }

    public static List<StubMapping> snapshotRecord() {
        return defaultInstance.get().takeSnapshotRecording();
    }

    public static List<StubMapping> snapshotRecord(RecordSpecBuilder spec) {
        return defaultInstance.get().takeSnapshotRecording(spec);
    }

    public List<StubMapping> takeSnapshotRecording() {
        return this.admin.snapshotRecord().getStubMappings();
    }

    public List<StubMapping> takeSnapshotRecording(RecordSpecBuilder spec) {
        return this.admin.snapshotRecord(spec.build()).getStubMappings();
    }

    public static void startRecording(String targetBaseUrl) {
        defaultInstance.get().startStubRecording(targetBaseUrl);
    }

    public static void startRecording(RecordSpecBuilder spec) {
        defaultInstance.get().startStubRecording(spec);
    }

    public void startStubRecording(String targetBaseUrl) {
        this.admin.startRecording(targetBaseUrl);
    }

    public void startStubRecording(RecordSpecBuilder spec) {
        this.admin.startRecording(spec.build());
    }

    public static SnapshotRecordResult stopRecording() {
        return defaultInstance.get().stopStubRecording();
    }

    public SnapshotRecordResult stopStubRecording() {
        return this.admin.stopRecording();
    }

    public static RecordingStatusResult getRecordingStatus() {
        return defaultInstance.get().getStubRecordingStatus();
    }

    public RecordingStatusResult getStubRecordingStatus() {
        return this.admin.getRecordingStatus();
    }

    public static RecordSpecBuilder recordSpec() {
        return new RecordSpecBuilder();
    }
}

