/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common.ssl;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.ssl.KeyStoreSource;
import com.google.common.io.Resources;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.EnumSet;
import java.util.Objects;

public class FileOrClasspathKeyStoreSource
extends KeyStoreSource {
    private final String path;

    public FileOrClasspathKeyStoreSource(String path, String keyStoreType, char[] keyStorePassword) {
        super(keyStoreType, keyStorePassword);
        this.path = path;
    }

    @Override
    protected InputStream createInputStream() {
        try {
            if (this.exists()) {
                return new FileInputStream(this.path);
            }
            try {
                URL pathUrl = new URL(this.path);
                return pathUrl.openStream();
            }
            catch (MalformedURLException ignored) {
                return Resources.getResource((String)this.path).openStream();
            }
        }
        catch (IOException e) {
            return Exceptions.throwUnchecked(e, InputStream.class);
        }
    }

    @Override
    public boolean exists() {
        return new File(this.path).isFile();
    }

    @Override
    public void save(KeyStore keyStore) {
        Path created = FileOrClasspathKeyStoreSource.createKeystoreFile(Paths.get(this.path, new String[0]));
        try (FileOutputStream fos = new FileOutputStream(created.toFile());){
            keyStore.store(fos, this.keyStorePassword);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            Exceptions.throwUnchecked(e);
        }
    }

    private static Path createKeystoreFile(Path path) {
        FileAttribute[] privateDirAttrs = new FileAttribute[]{};
        FileAttribute[] privateFileAttrs = new FileAttribute[]{};
        if (FileSystems.getDefault().supportedFileAttributeViews().contains("posix")) {
            privateDirAttrs = new FileAttribute[]{PosixFilePermissions.asFileAttribute(EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE))};
            privateFileAttrs = new FileAttribute[]{PosixFilePermissions.asFileAttribute(EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE))};
        }
        try {
            if (!Files.exists(path.getParent(), new LinkOption[0])) {
                Files.createDirectories(path.getParent(), privateDirAttrs);
            }
            return Files.createFile(path, privateFileAttrs);
        }
        catch (IOException e) {
            return Exceptions.throwUnchecked(e, Path.class);
        }
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FileOrClasspathKeyStoreSource that = (FileOrClasspathKeyStoreSource)o;
        return this.path.equals(that.path);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.path);
    }
}

