/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification.notmatched;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.NearMiss;
import com.github.tomakehurst.wiremock.verification.diff.Diff;
import com.github.tomakehurst.wiremock.verification.diff.PlainTextDiffRenderer;
import com.github.tomakehurst.wiremock.verification.notmatched.NotMatchedRenderer;
import java.util.List;

public class PlainTextStubNotMatchedRenderer
extends NotMatchedRenderer {
    private final PlainTextDiffRenderer diffRenderer = new PlainTextDiffRenderer();

    @Override
    public ResponseDefinition render(Admin admin, Request request) {
        String body;
        LoggedRequest loggedRequest = LoggedRequest.createFrom((Request)request.getOriginalRequest().or((Object)request));
        List<NearMiss> nearMisses = admin.findTopNearMissesFor(loggedRequest).getNearMisses();
        if (nearMisses.isEmpty()) {
            body = "No response could be served as there are no stub mappings in this WireMock instance.";
        } else {
            Diff firstDiff = nearMisses.get(0).getDiff();
            body = this.diffRenderer.render(firstDiff);
        }
        return ResponseDefinitionBuilder.responseDefinition().withStatus(404).withHeader("Content-Type", "text/plain").withBody(body).build();
    }
}

