/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.Xml;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.xmlunit.XMLUnitException;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.Comparison;
import org.xmlunit.diff.ComparisonControllers;
import org.xmlunit.diff.ComparisonListener;
import org.xmlunit.diff.ComparisonResult;
import org.xmlunit.diff.ComparisonType;
import org.xmlunit.diff.Diff;
import org.xmlunit.diff.DifferenceEvaluator;

public class EqualToXmlPattern
extends StringValuePattern {
    private static List<ComparisonType> COUNTED_COMPARISONS = ImmutableList.of((Object)ComparisonType.SCHEMA_LOCATION, (Object)ComparisonType.NO_NAMESPACE_SCHEMA_LOCATION, (Object)ComparisonType.NODE_TYPE, (Object)ComparisonType.NAMESPACE_URI, (Object)ComparisonType.TEXT_VALUE, (Object)ComparisonType.PROCESSING_INSTRUCTION_TARGET, (Object)ComparisonType.PROCESSING_INSTRUCTION_DATA, (Object)ComparisonType.ELEMENT_NUM_ATTRIBUTES, (Object)ComparisonType.ATTR_VALUE, (Object)ComparisonType.CHILD_NODELIST_LENGTH, (Object)ComparisonType.CHILD_NODELIST_SEQUENCE, (Object)ComparisonType.CHILD_LOOKUP, (Object[])new ComparisonType[]{ComparisonType.ATTR_NAME_LOOKUP});
    private static final DifferenceEvaluator IGNORE_UNCOUNTED_COMPARISONS = new DifferenceEvaluator(){

        public ComparisonResult evaluate(Comparison comparison, ComparisonResult outcome) {
            if (COUNTED_COMPARISONS.contains(comparison.getType()) && comparison.getControlDetails().getValue() != null) {
                return outcome;
            }
            return ComparisonResult.EQUAL;
        }
    };

    public EqualToXmlPattern(@JsonProperty(value="equalToXml") String expectedValue) {
        super(expectedValue);
    }

    public String getEqualToXml() {
        return this.expectedValue;
    }

    @Override
    public String getExpected() {
        return Xml.prettyPrint(this.getValue());
    }

    @Override
    public MatchResult match(final String value) {
        return new MatchResult(){

            @Override
            public boolean isExactMatch() {
                try {
                    Diff diff = DiffBuilder.compare((Object)Input.from((Object)EqualToXmlPattern.this.expectedValue)).withTest((Object)value).withComparisonController(ComparisonControllers.StopWhenDifferent).ignoreWhitespace().ignoreComments().withDifferenceEvaluator(IGNORE_UNCOUNTED_COMPARISONS).build();
                    return !diff.hasDifferences();
                }
                catch (XMLUnitException e) {
                    LocalNotifier.notifier().info("Failed to process XML. " + e.getMessage() + "\nExpected:\n" + EqualToXmlPattern.this.expectedValue + "\n\nActual:\n" + value);
                    return false;
                }
            }

            @Override
            public double getDistance() {
                final AtomicInteger totalComparisons = new AtomicInteger(0);
                final AtomicInteger differences = new AtomicInteger(0);
                Diff diff = DiffBuilder.compare((Object)Input.from((Object)EqualToXmlPattern.this.expectedValue)).withTest((Object)value).ignoreWhitespace().ignoreComments().withDifferenceEvaluator(IGNORE_UNCOUNTED_COMPARISONS).withComparisonListeners(new ComparisonListener[]{new ComparisonListener(){

                    public void comparisonPerformed(Comparison comparison, ComparisonResult outcome) {
                        if (COUNTED_COMPARISONS.contains(comparison.getType()) && comparison.getControlDetails().getValue() != null) {
                            totalComparisons.incrementAndGet();
                            if (outcome == ComparisonResult.DIFFERENT) {
                                differences.incrementAndGet();
                            }
                        }
                    }
                }}).build();
                LocalNotifier.notifier().info(Joiner.on((String)"\n").join(diff.getDifferences()));
                return differences.doubleValue() / totalComparisons.doubleValue();
            }
        };
    }
}

