/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.core;

import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.core.Container;
import com.github.tomakehurst.wiremock.core.MappingsSaver;
import com.github.tomakehurst.wiremock.core.StubServer;
import com.github.tomakehurst.wiremock.extension.ResponseDefinitionTransformer;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.github.tomakehurst.wiremock.global.GlobalSettingsHolder;
import com.github.tomakehurst.wiremock.global.RequestDelayControl;
import com.github.tomakehurst.wiremock.global.RequestDelaySpec;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.standalone.MappingsLoader;
import com.github.tomakehurst.wiremock.stubbing.InMemoryStubMappings;
import com.github.tomakehurst.wiremock.stubbing.ListStubMappingsResult;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.stubbing.StubMappings;
import com.github.tomakehurst.wiremock.verification.DisabledRequestJournal;
import com.github.tomakehurst.wiremock.verification.FindRequestsResult;
import com.github.tomakehurst.wiremock.verification.InMemoryRequestJournal;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.RequestJournal;
import com.github.tomakehurst.wiremock.verification.RequestJournalDisabledException;
import com.github.tomakehurst.wiremock.verification.VerificationResult;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;

public class WireMockApp
implements StubServer,
Admin {
    public static final String FILES_ROOT = "__files";
    public static final String ADMIN_CONTEXT_ROOT = "/__admin";
    private final StubMappings stubMappings;
    private final RequestJournal requestJournal;
    private final GlobalSettingsHolder globalSettingsHolder;
    private final RequestDelayControl requestDelayControl;
    private final boolean browserProxyingEnabled;
    private final MappingsLoader defaultMappingsLoader;
    private final Container container;
    private final MappingsSaver mappingsSaver;
    private final Map<String, ResponseDefinitionTransformer> transformers;
    private final FileSource rootFileSource;

    public WireMockApp(RequestDelayControl requestDelayControl, boolean browserProxyingEnabled, MappingsLoader defaultMappingsLoader, MappingsSaver mappingsSaver, boolean requestJournalDisabled, Optional<Integer> maxRequestJournalEntries, Map<String, ResponseDefinitionTransformer> transformers, FileSource rootFileSource, Container container) {
        this.requestDelayControl = requestDelayControl;
        this.browserProxyingEnabled = browserProxyingEnabled;
        this.defaultMappingsLoader = defaultMappingsLoader;
        this.mappingsSaver = mappingsSaver;
        this.globalSettingsHolder = new GlobalSettingsHolder();
        this.stubMappings = new InMemoryStubMappings();
        this.requestJournal = requestJournalDisabled ? new DisabledRequestJournal() : new InMemoryRequestJournal(maxRequestJournalEntries);
        this.transformers = transformers;
        this.rootFileSource = rootFileSource;
        this.container = container;
        this.loadDefaultMappings();
    }

    public GlobalSettingsHolder getGlobalSettingsHolder() {
        return this.globalSettingsHolder;
    }

    private void loadDefaultMappings() {
        this.loadMappingsUsing(this.defaultMappingsLoader);
    }

    public void loadMappingsUsing(MappingsLoader mappingsLoader) {
        mappingsLoader.loadMappingsInto(this.stubMappings);
    }

    @Override
    public ResponseDefinition serveStubFor(Request request) {
        ResponseDefinition baseResponseDefinition = this.stubMappings.serveFor(request);
        this.requestJournal.requestReceived(request);
        ResponseDefinition responseDefinition = this.applyTransformations(request, baseResponseDefinition, (List<ResponseDefinitionTransformer>)ImmutableList.copyOf(this.transformers.values()));
        if (!responseDefinition.wasConfigured() && request.isBrowserProxyRequest() && this.browserProxyingEnabled) {
            return ResponseDefinition.browserProxy(request);
        }
        return responseDefinition;
    }

    private ResponseDefinition applyTransformations(Request request, ResponseDefinition responseDefinition, List<ResponseDefinitionTransformer> transformers) {
        if (transformers.isEmpty()) {
            return responseDefinition;
        }
        ResponseDefinitionTransformer transformer = transformers.get(0);
        ResponseDefinition newResponseDef = transformer.applyGlobally() || responseDefinition.hasTransformer(transformer) ? transformer.transform(request, responseDefinition, this.rootFileSource.child(FILES_ROOT), responseDefinition.getTransformerParameters()) : responseDefinition;
        return this.applyTransformations(request, newResponseDef, transformers.subList(1, transformers.size()));
    }

    @Override
    public void addStubMapping(StubMapping stubMapping) {
        this.stubMappings.addMapping(stubMapping);
    }

    @Override
    public ListStubMappingsResult listAllStubMappings() {
        return new ListStubMappingsResult(this.stubMappings.getAll());
    }

    @Override
    public void saveMappings() {
        this.mappingsSaver.saveMappings(this.stubMappings);
    }

    @Override
    public void resetMappings() {
        this.stubMappings.reset();
        this.requestJournal.reset();
        this.requestDelayControl.clearDelay();
    }

    @Override
    public void resetRequests() {
        this.requestJournal.reset();
    }

    @Override
    public void resetToDefaultMappings() {
        this.resetMappings();
        this.loadDefaultMappings();
    }

    @Override
    public void resetScenarios() {
        this.stubMappings.resetScenarios();
    }

    @Override
    public VerificationResult countRequestsMatching(RequestPattern requestPattern) {
        try {
            return VerificationResult.withCount(this.requestJournal.countRequestsMatching(requestPattern));
        }
        catch (RequestJournalDisabledException e) {
            return VerificationResult.withRequestJournalDisabled();
        }
    }

    @Override
    public FindRequestsResult findRequestsMatching(RequestPattern requestPattern) {
        try {
            List<LoggedRequest> requests = this.requestJournal.getRequestsMatching(requestPattern);
            return FindRequestsResult.withRequests(requests);
        }
        catch (RequestJournalDisabledException e) {
            return FindRequestsResult.withRequestJournalDisabled();
        }
    }

    @Override
    public void updateGlobalSettings(GlobalSettings newSettings) {
        this.globalSettingsHolder.replaceWith(newSettings);
    }

    @Override
    public void addSocketAcceptDelay(RequestDelaySpec delaySpec) {
        this.requestDelayControl.setDelay(delaySpec.milliseconds());
    }

    public int port() {
        return this.container.port();
    }

    @Override
    public void shutdownServer() {
        this.container.shutdown();
    }
}

