/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty9;

import com.github.tomakehurst.wiremock.global.RequestDelayControl;
import com.github.tomakehurst.wiremock.jetty9.FaultInjectingHttpConnection;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;

public class FaultInjectingHttpConnectionFactory
extends HttpConnectionFactory {
    private final RequestDelayControl requestDelayControl;

    public FaultInjectingHttpConnectionFactory(RequestDelayControl requestDelayControl) {
        this.requestDelayControl = requestDelayControl;
    }

    public FaultInjectingHttpConnectionFactory(HttpConfiguration httpConfig, RequestDelayControl requestDelayControl) {
        super(httpConfig);
        this.requestDelayControl = requestDelayControl;
    }

    public Connection newConnection(Connector connector, EndPoint endPoint) {
        this.requestDelayControl.delayIfRequired();
        return this.configure((AbstractConnection)new FaultInjectingHttpConnection(this.getHttpConfiguration(), connector, endPoint), connector, endPoint);
    }
}

