/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.ProxySettings;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.HttpClientBuilder;

public class HttpClientFactory {
    public static final int DEFAULT_MAX_CONNECTIONS = 50;

    public static HttpClient createClient(int maxConnections, int timeoutMilliseconds, ProxySettings proxySettings) {
        HttpClientBuilder builder = HttpClientBuilder.create().disableAuthCaching().disableAutomaticRetries().disableCookieManagement().disableRedirectHandling().setMaxConnTotal(maxConnections).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(timeoutMilliseconds).build()).setSslcontext(HttpClientFactory.buildAllowAnythingSSLContext()).setHostnameVerifier((X509HostnameVerifier)new AllowAllHostnameVerifier());
        if (proxySettings != ProxySettings.NO_PROXY) {
            HttpHost proxyHost = new HttpHost(proxySettings.host(), proxySettings.port());
            builder.setProxy(proxyHost);
        }
        return builder.build();
    }

    private static SSLContext buildAllowAnythingSSLContext() {
        try {
            return new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build();
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, SSLContext.class);
        }
    }

    public static HttpClient createClient(int maxConnections, int timeoutMilliseconds) {
        return HttpClientFactory.createClient(maxConnections, timeoutMilliseconds, ProxySettings.NO_PROXY);
    }

    public static HttpClient createClient(int timeoutMilliseconds) {
        return HttpClientFactory.createClient(50, timeoutMilliseconds);
    }

    public static HttpClient createClient() {
        return HttpClientFactory.createClient(30000);
    }
}

