/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.junit;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import org.junit.rules.MethodRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class WireMockClassRule
implements MethodRule,
TestRule {
    private int port;
    private final WireMockServer wireMockServer;

    public WireMockClassRule(int port) {
        this.port = port;
        this.wireMockServer = new WireMockServer(port);
    }

    public WireMockClassRule() {
        this(8080);
    }

    public Statement apply(Statement base, FrameworkMethod method, Object target) {
        return this.apply(base, null);
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                if (WireMockClassRule.this.wireMockServer.isRunning()) {
                    try {
                        base.evaluate();
                    }
                    finally {
                        WireMock.reset();
                    }
                }
                WireMockClassRule.this.wireMockServer.start();
                WireMock.configureFor("localhost", WireMockClassRule.this.port);
                try {
                    base.evaluate();
                }
                finally {
                    WireMockClassRule.this.wireMockServer.stop();
                }
            }
        };
    }
}

