/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.github.tomakehurst.wiremock.global.RequestDelaySpec;
import com.github.tomakehurst.wiremock.http.AbstractRequestHandler;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.http.ResponseRenderer;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.verification.FindRequestsResult;
import com.github.tomakehurst.wiremock.verification.VerificationResult;

public class AdminRequestHandler
extends AbstractRequestHandler {
    private final Admin admin;

    public AdminRequestHandler(Admin admin, ResponseRenderer responseRenderer) {
        super(responseRenderer);
        this.admin = admin;
    }

    @Override
    public ResponseDefinition handleRequest(Request request) {
        LocalNotifier.notifier().info("Received request to " + request.getUrl() + " with body " + request.getBodyAsString());
        if (this.isNewMappingRequest(request)) {
            StubMapping newMapping = StubMapping.buildFrom(request.getBodyAsString());
            this.admin.addStubMapping(newMapping);
            return ResponseDefinition.created();
        }
        if (this.isResetRequest(request)) {
            this.admin.resetMappings();
            return ResponseDefinition.ok();
        }
        if (this.isResetScenariosRequest(request)) {
            this.admin.resetScenarios();
            return ResponseDefinition.ok();
        }
        if (this.isRequestCountRequest(request)) {
            return this.getRequestCount(request);
        }
        if (this.isFindRequestsRequest(request)) {
            return this.findRequests(request);
        }
        if (this.isGlobalSettingsUpdateRequest(request)) {
            GlobalSettings newSettings = Json.read(request.getBodyAsString(), GlobalSettings.class);
            this.admin.updateGlobalSettings(newSettings);
            return ResponseDefinition.ok();
        }
        if (this.isSocketDelayRequest(request)) {
            RequestDelaySpec delaySpec = Json.read(request.getBodyAsString(), RequestDelaySpec.class);
            this.admin.addSocketAcceptDelay(delaySpec);
            return ResponseDefinition.ok();
        }
        return ResponseDefinition.notFound();
    }

    private boolean isGlobalSettingsUpdateRequest(Request request) {
        return request.getMethod() == RequestMethod.POST && AdminRequestHandler.withoutAdminRoot(request.getUrl()).equals("/settings");
    }

    private ResponseDefinition getRequestCount(Request request) {
        RequestPattern requestPattern = RequestPattern.buildRequestPatternFrom(request.getBodyAsString());
        int matchingRequestCount = this.admin.countRequestsMatching(requestPattern);
        ResponseDefinition response = new ResponseDefinition(200, Json.write(new VerificationResult(matchingRequestCount)));
        response.setHeaders(new HttpHeaders(HttpHeader.httpHeader("Content-Type", "application/json")));
        return response;
    }

    private ResponseDefinition findRequests(Request request) {
        RequestPattern requestPattern = RequestPattern.buildRequestPatternFrom(request.getBodyAsString());
        FindRequestsResult result = this.admin.findRequestsMatching(requestPattern);
        ResponseDefinition response = new ResponseDefinition(200, Json.write(result));
        response.setHeaders(new HttpHeaders(HttpHeader.httpHeader("Content-Type", "application/json")));
        return response;
    }

    private boolean isResetRequest(Request request) {
        return request.getMethod() == RequestMethod.POST && AdminRequestHandler.withoutAdminRoot(request.getUrl()).equals("/reset");
    }

    private boolean isResetScenariosRequest(Request request) {
        return request.getMethod() == RequestMethod.POST && AdminRequestHandler.withoutAdminRoot(request.getUrl()).equals("/scenarios/reset");
    }

    private boolean isNewMappingRequest(Request request) {
        return request.getMethod() == RequestMethod.POST && AdminRequestHandler.withoutAdminRoot(request.getUrl()).equals("/mappings/new");
    }

    private boolean isRequestCountRequest(Request request) {
        return request.getMethod() == RequestMethod.POST && AdminRequestHandler.withoutAdminRoot(request.getUrl()).equals("/requests/count");
    }

    private boolean isFindRequestsRequest(Request request) {
        return request.getMethod() == RequestMethod.POST && AdminRequestHandler.withoutAdminRoot(request.getUrl()).equals("/requests/find");
    }

    private boolean isSocketDelayRequest(Request request) {
        return request.getMethod() == RequestMethod.POST && AdminRequestHandler.withoutAdminRoot(request.getUrl()).equals("/socket-delay");
    }

    private static String withoutAdminRoot(String url) {
        return url.replace("/__admin", "");
    }
}

