/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.servlet;

import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.ServletContainerUtils;
import com.github.tomakehurst.wiremock.mapping.Request;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class HttpServletRequestAdapter
implements Request {
    private final HttpServletRequest request;
    private String cachedBody;

    public HttpServletRequestAdapter(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public String getUrl() {
        String url = this.request.getRequestURI();
        if (!Strings.isNullOrEmpty((String)this.request.getContextPath())) {
            url = url.replace(this.request.getContextPath(), "");
        }
        if (!Strings.isNullOrEmpty((String)this.request.getQueryString())) {
            url = url + "?" + this.request.getQueryString();
        }
        return url;
    }

    @Override
    public String getAbsoluteUrl() {
        return this.request.getRequestURL().toString();
    }

    @Override
    public RequestMethod getMethod() {
        return RequestMethod.valueOf(this.request.getMethod().toUpperCase());
    }

    @Override
    public String getBodyAsString() {
        if (this.cachedBody == null) {
            try {
                this.cachedBody = CharStreams.toString((Readable)this.request.getReader());
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return this.cachedBody;
    }

    @Override
    public String getHeader(String key) {
        ArrayList<String> headerNames = Collections.list(this.request.getHeaderNames());
        for (String currentKey : headerNames) {
            if (!currentKey.toLowerCase().equals(key.toLowerCase())) continue;
            return this.request.getHeader(currentKey);
        }
        return null;
    }

    @Override
    public HttpHeader header(String key) {
        ArrayList<String> headerNames = Collections.list(this.request.getHeaderNames());
        for (String currentKey : headerNames) {
            if (!currentKey.toLowerCase().equals(key.toLowerCase())) continue;
            ArrayList<String> valueList = Collections.list(this.request.getHeaders(currentKey));
            return new HttpHeader(key, valueList);
        }
        return HttpHeader.absent(key);
    }

    @Override
    public ContentTypeHeader contentTypeHeader() {
        return this.getHeaders().getContentTypeHeader();
    }

    @Override
    public boolean containsHeader(String key) {
        return this.header(key).isPresent();
    }

    @Override
    public HttpHeaders getHeaders() {
        ArrayList headerList = Lists.newArrayList();
        for (String key : this.getAllHeaderKeys()) {
            headerList.add(this.header(key));
        }
        return new HttpHeaders(headerList);
    }

    @Override
    public Set<String> getAllHeaderKeys() {
        LinkedHashSet<String> headerKeys = new LinkedHashSet<String>();
        Enumeration headerNames = this.request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            headerKeys.add((String)headerNames.nextElement());
        }
        return headerKeys;
    }

    @Override
    public boolean isBrowserProxyRequest() {
        return ServletContainerUtils.isBrowserProxyRequest(this.request);
    }
}

