/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.mapping;

import com.github.tomakehurst.wiremock.mapping.Request;
import com.github.tomakehurst.wiremock.mapping.RequestHandler;
import com.github.tomakehurst.wiremock.mapping.RequestListener;
import com.github.tomakehurst.wiremock.mapping.Response;
import com.github.tomakehurst.wiremock.mapping.ResponseDefinition;
import com.github.tomakehurst.wiremock.servlet.ResponseRenderer;
import com.google.common.collect.Lists;
import java.util.List;

public abstract class AbstractRequestHandler
implements RequestHandler {
    protected List<RequestListener> listeners = Lists.newArrayList();
    protected final ResponseRenderer responseRenderer;

    public AbstractRequestHandler(ResponseRenderer responseRenderer) {
        this.responseRenderer = responseRenderer;
    }

    @Override
    public void addRequestListener(RequestListener requestListener) {
        this.listeners.add(requestListener);
    }

    @Override
    public Response handle(Request request) {
        ResponseDefinition responseDefinition = this.handleRequest(request);
        responseDefinition.setOriginalRequest(request);
        Response response = this.responseRenderer.render(responseDefinition);
        for (RequestListener listener : this.listeners) {
            listener.requestReceived(request, response);
        }
        return response;
    }

    protected abstract ResponseDefinition handleRequest(Request var1);
}

