/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;

public class HttpHeadersJsonDeserializer
extends JsonDeserializer<HttpHeaders> {
    public HttpHeaders deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonNode rootNode = parser.readValueAsTree();
        return new HttpHeaders(Iterables.transform(HttpHeadersJsonDeserializer.all(rootNode.getFields()), HttpHeadersJsonDeserializer.toHttpHeaders()));
    }

    private static Function<Map.Entry<String, JsonNode>, HttpHeader> toHttpHeaders() {
        return new Function<Map.Entry<String, JsonNode>, HttpHeader>(){

            public HttpHeader apply(Map.Entry<String, JsonNode> field) {
                String key = field.getKey();
                if (field.getValue().isArray()) {
                    return new HttpHeader(key, (Collection<String>)ImmutableList.copyOf((Iterable)Iterables.transform(HttpHeadersJsonDeserializer.all(field.getValue().getElements()), (Function)HttpHeadersJsonDeserializer.toStringValues())));
                }
                return new HttpHeader(key, field.getValue().getTextValue());
            }
        };
    }

    private static Function<JsonNode, String> toStringValues() {
        return new Function<JsonNode, String>(){

            public String apply(JsonNode node) {
                return node.getTextValue();
            }
        };
    }

    public static <T> Iterable<T> all(final Iterator<T> underlyingIterator) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return underlyingIterator;
            }
        };
    }
}

