/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.common.BinaryFile;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.TextFile;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractFileSource
implements FileSource {
    protected final File rootDirectory;

    public AbstractFileSource(File rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    protected abstract boolean readOnly();

    @Override
    public BinaryFile getBinaryFileNamed(String name) {
        return new BinaryFile(new File(this.rootDirectory, name));
    }

    @Override
    public TextFile getTextFileNamed(String name) {
        return new TextFile(new File(this.rootDirectory, name));
    }

    @Override
    public void createIfNecessary() {
        this.assertWritable();
        if (this.rootDirectory.exists() && this.rootDirectory.isFile()) {
            throw new IllegalStateException(this.rootDirectory + " already exists and is a file");
        }
        if (!this.rootDirectory.exists()) {
            this.rootDirectory.mkdirs();
        }
    }

    @Override
    public String getPath() {
        return this.rootDirectory.getPath();
    }

    @Override
    public List<TextFile> listFiles() {
        this.assertExistsAndIsDirectory();
        List<File> fileList = Arrays.asList(this.rootDirectory.listFiles(this.filesOnly()));
        return this.toTextFileList(fileList);
    }

    @Override
    public List<TextFile> listFilesRecursively() {
        this.assertExistsAndIsDirectory();
        ArrayList fileList = Lists.newArrayList();
        this.recursivelyAddFilesToList(this.rootDirectory, fileList);
        return this.toTextFileList(fileList);
    }

    private void recursivelyAddFilesToList(File root, List<File> fileList) {
        File[] files;
        for (File file : files = root.listFiles()) {
            if (file.isDirectory()) {
                this.recursivelyAddFilesToList(file, fileList);
                continue;
            }
            fileList.add(file);
        }
    }

    private List<TextFile> toTextFileList(List<File> fileList) {
        return Lists.newArrayList((Iterable)Iterables.transform(fileList, (Function)new Function<File, TextFile>(){

            public TextFile apply(File input) {
                return new TextFile(input.getPath());
            }
        }));
    }

    private void assertExistsAndIsDirectory() {
        if (this.rootDirectory.exists() && !this.rootDirectory.isDirectory()) {
            throw new RuntimeException(this.rootDirectory + " is not a directory");
        }
        if (!this.rootDirectory.exists()) {
            throw new RuntimeException(this.rootDirectory + " does not exist");
        }
    }

    @Override
    public void writeTextFile(String name, String contents) {
        this.assertExistsAndIsDirectory();
        this.assertWritable();
        File toFile = new File(this.rootDirectory, name);
        try {
            Files.write((CharSequence)contents, (File)toFile, (Charset)Charsets.UTF_8);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private void assertWritable() {
        if (this.readOnly()) {
            throw new UnsupportedOperationException("Can't write to read only file sources");
        }
    }

    private FileFilter filesOnly() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile();
            }
        };
    }
}

