/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.mapping;

import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.mapping.JsonMappingBinder;
import com.github.tomakehurst.wiremock.mapping.Request;
import com.github.tomakehurst.wiremock.mapping.ValuePattern;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public class RequestPattern {
    private String urlPattern;
    private String url;
    private RequestMethod method;
    private Map<String, ValuePattern> headers;
    private List<ValuePattern> bodyPatterns;

    public RequestPattern(RequestMethod method, String url, Map<String, ValuePattern> headers) {
        this.url = url;
        this.method = method;
        this.headers = headers;
    }

    public RequestPattern(RequestMethod method) {
        this.method = method;
    }

    public RequestPattern(RequestMethod method, String url) {
        this.url = url;
        this.method = method;
    }

    public RequestPattern() {
    }

    private void assertIsInValidState() {
        if (this.url != null && this.urlPattern != null) {
            throw new IllegalStateException("URL and URL pattern may not be set simultaneously");
        }
    }

    public boolean isMatchedBy(Request request) {
        return this.urlIsMatch(request) && this.methodMatches(request) && this.headersMatch(request) && this.bodyMatches(request);
    }

    private boolean urlIsMatch(Request request) {
        String candidateUrl = request.getUrl();
        boolean matched = this.urlPattern == null ? this.url.equals(candidateUrl) : candidateUrl.matches(this.urlPattern);
        return matched;
    }

    private boolean methodMatches(Request request) {
        boolean matched;
        boolean bl = matched = this.method == RequestMethod.ANY || request.getMethod() == this.method;
        if (!matched) {
            LocalNotifier.notifier().info(String.format("URL %s is match, but method %s is not", new Object[]{request.getUrl(), request.getMethod()}));
        }
        return matched;
    }

    private boolean headersMatch(Request request) {
        if (this.headers == null) {
            return true;
        }
        for (Map.Entry<String, ValuePattern> header : this.headers.entrySet()) {
            ValuePattern headerPattern = header.getValue();
            String key = header.getKey();
            if (request.containsHeader(key) && headerPattern.isMatchFor(request.getHeader(key))) continue;
            LocalNotifier.notifier().info(String.format("URL %s is match, but header %s is not. For a match, value should %s", request.getUrl(), key, headerPattern.toString()));
            return false;
        }
        return true;
    }

    private boolean bodyMatches(Request request) {
        if (this.bodyPatterns == null) {
            return true;
        }
        boolean matches = Iterables.all(this.bodyPatterns, ValuePattern.matching(request.getBodyAsString()));
        if (!matches) {
            LocalNotifier.notifier().info(String.format("URL %s is match, but body is not: %s", request.getUrl(), request.getBodyAsString()));
        }
        return matches;
    }

    public String getUrlPattern() {
        return this.urlPattern;
    }

    public void setUrlPattern(String urlPattern) {
        this.urlPattern = urlPattern;
        this.assertIsInValidState();
    }

    public RequestMethod getMethod() {
        return this.method;
    }

    public void setMethod(RequestMethod method) {
        this.method = method;
    }

    public Map<String, ValuePattern> getHeaders() {
        return this.headers;
    }

    public void addHeader(String key, ValuePattern pattern) {
        if (this.headers == null) {
            this.headers = Maps.newLinkedHashMap();
        }
        this.headers.put(key, pattern);
    }

    public void setHeaders(Map<String, ValuePattern> headers) {
        this.headers = headers;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
        this.assertIsInValidState();
    }

    public List<ValuePattern> getBodyPatterns() {
        return this.bodyPatterns;
    }

    public void setBodyPatterns(List<ValuePattern> bodyPatterns) {
        this.bodyPatterns = bodyPatterns;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bodyPatterns == null ? 0 : ((Object)this.bodyPatterns).hashCode());
        result = 31 * result + (this.headers == null ? 0 : ((Object)this.headers).hashCode());
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        result = 31 * result + (this.urlPattern == null ? 0 : this.urlPattern.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestPattern other = (RequestPattern)obj;
        if (this.bodyPatterns == null ? other.bodyPatterns != null : !((Object)this.bodyPatterns).equals(other.bodyPatterns)) {
            return false;
        }
        if (this.headers == null ? other.headers != null : !((Object)this.headers).equals(other.headers)) {
            return false;
        }
        if (this.method != other.method) {
            return false;
        }
        if (this.url == null ? other.url != null : !this.url.equals(other.url)) {
            return false;
        }
        return !(this.urlPattern == null ? other.urlPattern != null : !this.urlPattern.equals(other.urlPattern));
    }

    public String toString() {
        return JsonMappingBinder.write(this);
    }
}

