/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification;

import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.mapping.Request;
import java.util.Set;

public class LoggedRequest
implements Request {
    private String url;
    private String absoluteUrl;
    private RequestMethod method;
    private final HttpHeaders headers = new HttpHeaders();
    private String body;
    private boolean isBrowserProxyRequest;

    public static LoggedRequest createFrom(Request request) {
        LoggedRequest loggedRequest = new LoggedRequest();
        loggedRequest.url = request.getUrl();
        loggedRequest.absoluteUrl = request.getAbsoluteUrl();
        loggedRequest.method = request.getMethod();
        loggedRequest.body = request.getBodyAsString();
        for (String key : request.getAllHeaderKeys()) {
            loggedRequest.headers.put(key, request.getHeader(key));
        }
        loggedRequest.isBrowserProxyRequest = request.isBrowserProxyRequest();
        return loggedRequest;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getAbsoluteUrl() {
        return this.absoluteUrl;
    }

    @Override
    public RequestMethod getMethod() {
        return this.method;
    }

    @Override
    public String getHeader(String key) {
        for (String currentKey : this.headers.keySet()) {
            if (!currentKey.toLowerCase().equals(key.toLowerCase())) continue;
            return (String)this.headers.get(currentKey);
        }
        return null;
    }

    @Override
    public boolean containsHeader(String key) {
        return this.getHeader(key) != null;
    }

    @Override
    public String getBodyAsString() {
        return this.body;
    }

    @Override
    public Set<String> getAllHeaderKeys() {
        return this.headers.keySet();
    }

    @Override
    public boolean isBrowserProxyRequest() {
        return this.isBrowserProxyRequest;
    }
}

