/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.client;

import com.github.tomakehurst.wiremock.client.UrlMatchingStrategy;
import com.github.tomakehurst.wiremock.client.ValueMatchingStrategy;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.mapping.RequestPattern;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;

public class RequestPatternBuilder {
    private RequestMethod method;
    private UrlMatchingStrategy urlMatchingStrategy;
    private Map<String, ValueMatchingStrategy> headers = Maps.newLinkedHashMap();
    private List<ValueMatchingStrategy> bodyPatterns = Lists.newArrayList();

    public RequestPatternBuilder(RequestMethod method, UrlMatchingStrategy urlMatchingStrategy) {
        this.method = method;
        this.urlMatchingStrategy = urlMatchingStrategy;
    }

    public RequestPatternBuilder withHeader(String key, ValueMatchingStrategy headerMatchingStrategy) {
        this.headers.put(key, headerMatchingStrategy);
        return this;
    }

    public RequestPatternBuilder withRequestBody(ValueMatchingStrategy bodyMatchingStrategy) {
        this.bodyPatterns.add(bodyMatchingStrategy);
        return this;
    }

    public RequestPattern build() {
        RequestPattern requestPattern = new RequestPattern();
        requestPattern.setMethod(this.method);
        this.urlMatchingStrategy.contributeTo(requestPattern);
        for (Map.Entry<String, ValueMatchingStrategy> header : this.headers.entrySet()) {
            requestPattern.addHeader(header.getKey(), header.getValue().asValuePattern());
        }
        if (!this.bodyPatterns.isEmpty()) {
            requestPattern.setBodyPatterns(Lists.newArrayList((Iterable)Iterables.transform(this.bodyPatterns, ValueMatchingStrategy.toValuePattern)));
        }
        return requestPattern;
    }
}

