/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CollectorContext;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorState;
import com.networknt.schema.ValidatorTypeCode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class OneOfValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(OneOfValidator.class);
    private final List<JsonSchema> schemas = new ArrayList<JsonSchema>();

    public OneOfValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.ONE_OF, validationContext);
        int size = schemaNode.size();
        for (int i = 0; i < size; ++i) {
            JsonNode childNode = schemaNode.get(i);
            this.schemas.add(validationContext.newSchema(schemaPath + "/" + i, childNode, parentSchema));
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        CollectorContext collectorContext = CollectorContext.getInstance();
        Collection<String> backupEvaluatedItems = collectorContext.getEvaluatedItems();
        Collection<String> backupEvaluatedProperties = collectorContext.getEvaluatedProperties();
        collectorContext.resetEvaluatedItems();
        collectorContext.resetEvaluatedProperties();
        try {
            this.debug(logger, node, rootNode, at);
            ValidatorState state = (ValidatorState)collectorContext.get("com.networknt.schema.ValidatorState");
            state.setComplexValidator(true);
            int numberOfValidSchema = 0;
            LinkedHashSet<ValidationMessage> childErrors = new LinkedHashSet<ValidationMessage>();
            for (JsonSchema schema : this.schemas) {
                Set<ValidationMessage> schemaErrors = null;
                state.setMatchedNode(true);
                schemaErrors = !state.isWalkEnabled() ? schema.validate(node, rootNode, at) : schema.walk(node, rootNode, at, state.isValidationEnabled());
                if (schemaErrors.isEmpty()) {
                    if (!state.hasMatchedNode()) continue;
                    ++numberOfValidSchema;
                }
                if (numberOfValidSchema > 1) {
                    collectorContext.resetEvaluatedItems();
                    collectorContext.resetEvaluatedProperties();
                    break;
                }
                childErrors.addAll(schemaErrors);
            }
            if (numberOfValidSchema != 1) {
                ValidationMessage message = this.buildValidationMessage(at, Integer.toString(numberOfValidSchema));
                if (this.failFast) {
                    throw new JsonSchemaException(message);
                }
                errors.add(message);
                errors.addAll(childErrors);
            }
            if (errors.isEmpty()) {
                state.setMatchedNode(true);
            }
            OneOfValidator.resetValidatorState();
            Set set = Collections.unmodifiableSet(errors);
            return set;
        }
        finally {
            if (errors.isEmpty()) {
                collectorContext.getEvaluatedItems().addAll(backupEvaluatedItems);
                collectorContext.getEvaluatedProperties().addAll(backupEvaluatedProperties);
            } else {
                collectorContext.setEvaluatedItems(backupEvaluatedItems);
                collectorContext.setEvaluatedProperties(backupEvaluatedProperties);
            }
        }
    }

    private static void resetValidatorState() {
        ValidatorState state = (ValidatorState)CollectorContext.getInstance().get("com.networknt.schema.ValidatorState");
        state.setComplexValidator(false);
        state.setMatchedNode(true);
    }

    @Override
    public Set<ValidationMessage> walk(JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        LinkedHashSet<ValidationMessage> validationMessages = new LinkedHashSet<ValidationMessage>();
        if (shouldValidateSchema) {
            validationMessages.addAll(this.validate(node, rootNode, at));
        } else {
            for (JsonSchema schema : this.schemas) {
                schema.walk(node, rootNode, at, shouldValidateSchema);
            }
        }
        return validationMessages;
    }

    @Override
    public void preloadJsonSchema() {
        for (JsonSchema schema : this.schemas) {
            schema.initializeValidators();
        }
    }
}

