/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.networknt.schema.JsonMetaSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import java.util.Optional;
import wiremock.com.fasterxml.jackson.databind.JsonNode;

public final class SpecVersionDetector {
    private static final String SCHEMA_TAG = "$schema";

    private SpecVersionDetector() {
    }

    public static SpecVersion.VersionFlag detect(JsonNode jsonNode) {
        return SpecVersionDetector.detectOptionalVersion(jsonNode).orElseThrow(() -> new JsonSchemaException("'$schema' tag is not present"));
    }

    public static Optional<SpecVersion.VersionFlag> detectOptionalVersion(JsonNode jsonNode) {
        return Optional.ofNullable(jsonNode.get(SCHEMA_TAG)).map(schemaTag -> {
            boolean forceHttps = true;
            boolean removeEmptyFragmentSuffix = true;
            String schemaTagValue = schemaTag.asText();
            String schemaUri = JsonSchemaFactory.normalizeMetaSchemaUri(schemaTagValue, true, true);
            SpecVersion.VersionFlag version = SpecVersionDetector.detect(schemaUri);
            if (null == version) {
                throw new JsonSchemaException("'" + schemaTagValue + "' is unrecognizable schema");
            }
            return version;
        });
    }

    public static Optional<SpecVersion.VersionFlag> detectOptionalVersion(String schemaUri) {
        return Optional.ofNullable(SpecVersionDetector.detect(schemaUri));
    }

    private static SpecVersion.VersionFlag detect(String schemaUri) {
        if (null != schemaUri) {
            if (schemaUri.equals(JsonMetaSchema.getV4().getUri())) {
                return SpecVersion.VersionFlag.V4;
            }
            if (schemaUri.equals(JsonMetaSchema.getV6().getUri())) {
                return SpecVersion.VersionFlag.V6;
            }
            if (schemaUri.equals(JsonMetaSchema.getV7().getUri())) {
                return SpecVersion.VersionFlag.V7;
            }
            if (schemaUri.equals(JsonMetaSchema.getV201909().getUri())) {
                return SpecVersion.VersionFlag.V201909;
            }
            if (schemaUri.equals(JsonMetaSchema.getV202012().getUri())) {
                return SpecVersion.VersionFlag.V202012;
            }
        }
        return null;
    }
}

