/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CollectorContext;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonType;
import com.networknt.schema.RequiredValidator;
import com.networknt.schema.TypeValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorState;
import com.networknt.schema.ValidatorTypeCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class AnyOfValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(RequiredValidator.class);
    private static final String DISCRIMINATOR_REMARK = "and the discriminator-selected candidate schema didn't pass validation";
    private final List<JsonSchema> schemas = new ArrayList<JsonSchema>();
    private final ValidationContext.DiscriminatorContext discriminatorContext;

    public AnyOfValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.ANY_OF, validationContext);
        this.validationContext = validationContext;
        int size = schemaNode.size();
        for (int i = 0; i < size; ++i) {
            this.schemas.add(new JsonSchema(validationContext, schemaPath + "/" + i, parentSchema.getCurrentUri(), schemaNode.get(i), parentSchema));
        }
        this.discriminatorContext = this.validationContext.getConfig().isOpenAPI3StyleDiscriminators() ? new ValidationContext.DiscriminatorContext() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        ValidatorState state = (ValidatorState)CollectorContext.getInstance().get("com.networknt.schema.ValidatorState");
        if (this.validationContext.getConfig().isOpenAPI3StyleDiscriminators()) {
            this.validationContext.enterDiscriminatorContext(this.discriminatorContext, at);
        }
        boolean initialHasMatchedNode = state.hasMatchedNode();
        Set<Object> allErrors = new LinkedHashSet();
        Set<String> backupEvaluatedProperties = CollectorContext.getInstance().copyEvaluatedProperties();
        CollectorContext.getInstance().getEvaluatedProperties().clear();
        try {
            int numberOfValidSubSchemas = 0;
            for (int i = 0; i < this.schemas.size(); ++i) {
                Set<ValidationMessage> set;
                TypeValidator typeValidator;
                JsonSchema schema = this.schemas.get(i);
                state.setMatchedNode(initialHasMatchedNode);
                String typeValidatorName = this.schemas.get(i).getSchemaPath() + "/type";
                if (schema.getValidators().containsKey(typeValidatorName) && (typeValidator = (TypeValidator)schema.getValidators().get(typeValidatorName)).getSchemaType() != JsonType.UNION && !typeValidator.equalsToSchemaType(node)) {
                    allErrors.add(this.buildValidationMessage(at, typeValidator.getSchemaType().toString()));
                    continue;
                }
                Set<ValidationMessage> errors = !state.isWalkEnabled() ? schema.validate(node, rootNode, at) : schema.walk(node, rootNode, at, true);
                if (errors.isEmpty()) {
                    if (!state.hasMatchedNode()) continue;
                    ++numberOfValidSubSchemas;
                }
                if (errors.isEmpty() && !this.validationContext.getConfig().isOpenAPI3StyleDiscriminators()) {
                    allErrors.clear();
                    set = errors;
                    return set;
                }
                if (this.validationContext.getConfig().isOpenAPI3StyleDiscriminators() && this.discriminatorContext.isDiscriminatorMatchFound()) {
                    if (!errors.isEmpty()) {
                        errors.add(this.buildValidationMessage(at, DISCRIMINATOR_REMARK));
                        allErrors.addAll(errors);
                    } else {
                        allErrors.clear();
                    }
                    set = errors;
                    return set;
                }
                allErrors.addAll(errors);
            }
            Set childNotRequiredErrors = allErrors.stream().filter(error -> !ValidatorTypeCode.REQUIRED.getValue().equals(error.getType())).collect(Collectors.toSet());
            if (numberOfValidSubSchemas >= 1 && childNotRequiredErrors.isEmpty()) {
                allErrors = childNotRequiredErrors;
            }
            if (this.validationContext.getConfig().isOpenAPI3StyleDiscriminators() && this.discriminatorContext.isActive()) {
                HashSet<ValidationMessage> errors = new HashSet<ValidationMessage>();
                errors.add(this.buildValidationMessage(at, "based on the provided discriminator. No alternative could be chosen based on the discriminator property"));
                Set<ValidationMessage> set = Collections.unmodifiableSet(errors);
                return set;
            }
        }
        finally {
            if (this.validationContext.getConfig().isOpenAPI3StyleDiscriminators()) {
                this.validationContext.leaveDiscriminatorContextImmediately(at);
            }
            if (allErrors.isEmpty()) {
                state.setMatchedNode(true);
            } else {
                CollectorContext.getInstance().getEvaluatedProperties().clear();
            }
            CollectorContext.getInstance().getEvaluatedProperties().addAll(backupEvaluatedProperties);
        }
        return Collections.unmodifiableSet(allErrors);
    }

    @Override
    public Set<ValidationMessage> walk(JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        if (shouldValidateSchema) {
            return this.validate(node, rootNode, at);
        }
        for (JsonSchema schema : this.schemas) {
            schema.walk(node, rootNode, at, false);
        }
        return new LinkedHashSet<ValidationMessage>();
    }

    @Override
    public void preloadJsonSchema() {
        this.preloadJsonSchemas(this.schemas);
    }
}

