/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.github.jknack.handlebars.context;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.LinkedHashSet;
import java.util.Set;
import wiremock.com.github.jknack.handlebars.ValueResolver;
import wiremock.com.github.jknack.handlebars.context.MemberValueResolver;

public class FieldValueResolver
extends MemberValueResolver<FieldWrapper> {
    public static final ValueResolver INSTANCE = new FieldValueResolver();

    @Override
    public boolean matches(FieldWrapper field, String name) {
        return !this.isStatic(field) && field.getName().equals(name);
    }

    @Override
    protected Object invokeMember(FieldWrapper field, Object context) {
        try {
            return field.get(context);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Shouldn't be illegal to access field '" + field.getName() + "'", ex);
        }
    }

    @Override
    protected Set<FieldWrapper> members(Class<?> clazz) {
        LinkedHashSet<FieldWrapper> members = new LinkedHashSet<FieldWrapper>();
        if (clazz.isArray()) {
            members.add(ArrayLengthMember.LENGTH);
        } else {
            Class<?> targetClass = clazz;
            do {
                Field[] fields;
                for (Field field : fields = targetClass.getDeclaredFields()) {
                    FieldMember wrapper = new FieldMember(field);
                    if (!this.matches(wrapper, this.memberName(wrapper))) continue;
                    members.add(wrapper);
                }
            } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
        }
        return members;
    }

    @Override
    protected String memberName(FieldWrapper member) {
        return member.getName();
    }

    private static final class ArrayLengthMember
    implements FieldWrapper {
        public static final FieldWrapper LENGTH = new ArrayLengthMember();

        private ArrayLengthMember() {
        }

        @Override
        public Class<?> getDeclaringClass() {
            return null;
        }

        @Override
        public String getName() {
            return "length";
        }

        @Override
        public int getModifiers() {
            return 1;
        }

        @Override
        public boolean isSynthetic() {
            return false;
        }

        @Override
        public Object get(Object obj) throws IllegalAccessException {
            return Array.getLength(obj);
        }
    }

    private static class FieldMember
    extends AccessibleObject
    implements FieldWrapper {
        private Field field;

        FieldMember(Field field) {
            this.field = field;
        }

        @Override
        public Class<?> getDeclaringClass() {
            return this.field.getDeclaringClass();
        }

        @Override
        public String getName() {
            return this.field.getName();
        }

        @Override
        public int getModifiers() {
            return this.field.getModifiers();
        }

        @Override
        public boolean isSynthetic() {
            return this.field.isSynthetic();
        }

        @Override
        public Object get(Object obj) throws IllegalAccessException {
            return this.field.get(obj);
        }

        public String toString() {
            return this.field.toString();
        }

        @Override
        public boolean isAccessible() {
            return this.field.isAccessible();
        }

        @Override
        public void setAccessible(boolean flag) {
            this.field.setAccessible(flag);
        }
    }

    public static interface FieldWrapper
    extends Member {
        public Object get(Object var1) throws IllegalAccessException;
    }
}

