/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.matching.AbsentPattern;
import com.github.tomakehurst.wiremock.matching.NamedValueMatcher;
import com.github.tomakehurst.wiremock.matching.StringValuePatternJsonDeserializer;
import java.lang.reflect.Constructor;
import wiremock.com.fasterxml.jackson.annotation.JsonIgnore;
import wiremock.com.fasterxml.jackson.annotation.JsonProperty;
import wiremock.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import wiremock.com.google.common.base.Objects;
import wiremock.com.google.common.base.Predicate;
import wiremock.com.google.common.collect.FluentIterable;

@JsonDeserialize(using=StringValuePatternJsonDeserializer.class)
public abstract class StringValuePattern
implements NamedValueMatcher<String> {
    public static final AbsentPattern ABSENT = new AbsentPattern(null);
    protected final String expectedValue;

    public StringValuePattern(String expectedValue) {
        this.expectedValue = expectedValue;
    }

    @JsonIgnore
    public boolean isPresent() {
        return this != ABSENT;
    }

    public Boolean isAbsent() {
        return this != ABSENT ? null : Boolean.valueOf(true);
    }

    @JsonIgnore
    public Boolean nullSafeIsAbsent() {
        return this == ABSENT;
    }

    @JsonIgnore
    public String getValue() {
        return this.expectedValue;
    }

    public String toString() {
        return this.getName() + " " + this.getValue();
    }

    @Override
    public final String getName() {
        Constructor<?> constructor = FluentIterable.of(this.getClass().getDeclaredConstructors()).firstMatch(new Predicate<Constructor<?>>(){

            @Override
            public boolean apply(Constructor<?> input) {
                return input.getParameterAnnotations().length > 0 && input.getParameterAnnotations()[0].length > 0 && input.getParameterAnnotations()[0][0] instanceof JsonProperty;
            }
        }).orNull();
        if (constructor == null) {
            throw new IllegalStateException("Constructor must have a first parameter annotatated with JsonProperty(\"<operator name>\")");
        }
        JsonProperty jsonPropertyAnnotation = (JsonProperty)constructor.getParameterAnnotations()[0][0];
        return jsonPropertyAnnotation.value();
    }

    @Override
    public String getExpected() {
        return this.getValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringValuePattern that = (StringValuePattern)o;
        return Objects.equal(this.expectedValue, that.expectedValue);
    }

    public int hashCode() {
        return Objects.hashCode(this.expectedValue);
    }
}

