/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.io;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.io.AbstractTemplateSource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import wiremock.org.apache.commons.lang3.Validate;

public class URLTemplateSource
extends AbstractTemplateSource {
    private URL resource;
    private Long lastModified;
    private String filename;

    public URLTemplateSource(String filename, URL resource) {
        this.filename = Validate.notEmpty(filename, "The filename is required.", new Object[0]);
        this.resource = Validate.notNull(resource, "A resource is required.", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String content() throws IOException {
        int bufferSize = 1024;
        try (Reader reader = null;){
            int len;
            reader = this.reader();
            char[] cbuf = new char[1024];
            StringBuilder sb = new StringBuilder(1024);
            while ((len = reader.read(cbuf, 0, 1024)) != -1) {
                sb.append(cbuf, 0, len);
            }
            String string = sb.toString();
            return string;
        }
    }

    @Override
    public String filename() {
        return this.filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long lastModified() {
        URLTemplateSource uRLTemplateSource = this;
        synchronized (uRLTemplateSource) {
            if (this.lastModified == null) {
                this.lastModified = this.lastModified(this.resource);
            }
            return this.lastModified;
        }
    }

    protected Reader reader() throws IOException {
        InputStream in = this.resource.openStream();
        return new InputStreamReader(in, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private long lastModified(URL resource) {
        URLConnection uc;
        block17: {
            URL jarURL;
            uc = null;
            uc = resource.openConnection();
            if (!(uc instanceof JarURLConnection) || !(jarURL = ((JarURLConnection)uc).getJarFileURL()).getProtocol().equals("file")) break block17;
            uc = null;
            String file = jarURL.getFile();
            long l = new File(file).lastModified();
            try {
                InputStream is;
                if (uc != null && (is = uc.getInputStream()) != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                Handlebars.warn("Can't close: %s", resource);
            }
            return l;
        }
        long l = uc.getLastModified();
        try {
            InputStream is;
            if (uc != null && (is = uc.getInputStream()) != null) {
                is.close();
            }
        }
        catch (IOException e) {
            Handlebars.warn("Can't close: %s", resource);
        }
        return l;
        catch (IOException ex) {
            long l2;
            try {
                Handlebars.warn("Can't get last modified date of: %s", resource);
                l2 = -1L;
            }
            catch (Throwable throwable) {
                try {
                    InputStream is;
                    if (uc != null && (is = uc.getInputStream()) != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    Handlebars.warn("Can't close: %s", resource);
                }
                throw throwable;
            }
            try {
                InputStream is;
                if (uc != null && (is = uc.getInputStream()) != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                Handlebars.warn("Can't close: %s", resource);
            }
            return l2;
        }
    }
}

