/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.eclipse.jetty.client.http;

import wiremock.org.eclipse.jetty.client.HttpChannel;
import wiremock.org.eclipse.jetty.client.HttpExchange;
import wiremock.org.eclipse.jetty.client.HttpReceiver;
import wiremock.org.eclipse.jetty.client.HttpSender;
import wiremock.org.eclipse.jetty.client.api.Response;
import wiremock.org.eclipse.jetty.client.api.Result;
import wiremock.org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import wiremock.org.eclipse.jetty.client.http.HttpReceiverOverHTTP;
import wiremock.org.eclipse.jetty.client.http.HttpSenderOverHTTP;
import wiremock.org.eclipse.jetty.http.HttpFields;
import wiremock.org.eclipse.jetty.http.HttpHeader;
import wiremock.org.eclipse.jetty.http.HttpHeaderValue;
import wiremock.org.eclipse.jetty.http.HttpMethod;
import wiremock.org.eclipse.jetty.http.HttpVersion;

public class HttpChannelOverHTTP
extends HttpChannel {
    private final HttpConnectionOverHTTP connection;
    private final HttpSenderOverHTTP sender;
    private final HttpReceiverOverHTTP receiver;

    public HttpChannelOverHTTP(HttpConnectionOverHTTP connection) {
        super(connection.getHttpDestination());
        this.connection = connection;
        this.sender = this.newHttpSender();
        this.receiver = this.newHttpReceiver();
    }

    protected HttpSenderOverHTTP newHttpSender() {
        return new HttpSenderOverHTTP(this);
    }

    protected HttpReceiverOverHTTP newHttpReceiver() {
        return new HttpReceiverOverHTTP(this);
    }

    @Override
    protected HttpSender getHttpSender() {
        return this.sender;
    }

    @Override
    protected HttpReceiver getHttpReceiver() {
        return this.receiver;
    }

    public HttpConnectionOverHTTP getHttpConnection() {
        return this.connection;
    }

    @Override
    public void send() {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange != null) {
            this.sender.send(exchange);
        }
    }

    @Override
    public void release() {
        this.connection.release();
    }

    public void receive() {
        this.receiver.receive();
    }

    @Override
    public void exchangeTerminated(HttpExchange exchange, Result result) {
        super.exchangeTerminated(exchange, result);
        Response response = result.getResponse();
        HttpFields responseHeaders = response.getHeaders();
        String closeReason = null;
        if (result.isFailed()) {
            closeReason = "failure";
        } else if (this.receiver.isShutdown()) {
            closeReason = "server close";
        }
        if (closeReason == null) {
            if (response.getVersion().compareTo(HttpVersion.HTTP_1_1) < 0) {
                boolean keepAlive = responseHeaders.contains(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE.asString());
                boolean connect = HttpMethod.CONNECT.is(exchange.getRequest().getMethod());
                if (!keepAlive && !connect) {
                    closeReason = "http/1.0";
                }
            } else if (responseHeaders.contains(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.asString())) {
                closeReason = "http/1.1";
            }
        }
        if (closeReason != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closing, reason: {} - {}", closeReason, this.connection);
            }
            this.connection.close();
        } else {
            this.release();
        }
    }

    @Override
    public String toString() {
        return String.format("%s[send=%s,recv=%s]", super.toString(), this.sender, this.receiver);
    }
}

