/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.standalone;

import com.github.tomakehurst.wiremock.common.AsynchronousResponseSettings;
import com.github.tomakehurst.wiremock.common.ConsoleNotifier;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.HttpsSettings;
import com.github.tomakehurst.wiremock.common.JettySettings;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.common.ProxySettings;
import com.github.tomakehurst.wiremock.common.SingleRootFileSource;
import com.github.tomakehurst.wiremock.core.MappingsSaver;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.extension.ExtensionLoader;
import com.github.tomakehurst.wiremock.extension.ResponseDefinitionTransformer;
import com.github.tomakehurst.wiremock.extension.responsetemplating.ResponseTemplateTransformer;
import com.github.tomakehurst.wiremock.http.CaseInsensitiveKey;
import com.github.tomakehurst.wiremock.http.HttpServerFactory;
import com.github.tomakehurst.wiremock.http.ThreadPoolFactory;
import com.github.tomakehurst.wiremock.http.trafficlistener.ConsoleNotifyingWiremockNetworkTrafficListener;
import com.github.tomakehurst.wiremock.http.trafficlistener.DoNothingWiremockNetworkTrafficListener;
import com.github.tomakehurst.wiremock.http.trafficlistener.WiremockNetworkTrafficListener;
import com.github.tomakehurst.wiremock.jetty9.QueuedThreadPoolFactory;
import com.github.tomakehurst.wiremock.security.Authenticator;
import com.github.tomakehurst.wiremock.security.BasicAuthenticator;
import com.github.tomakehurst.wiremock.security.NoAuthenticator;
import com.github.tomakehurst.wiremock.standalone.JsonFileMappingsSource;
import com.github.tomakehurst.wiremock.standalone.MappingsLoader;
import com.github.tomakehurst.wiremock.standalone.MappingsSource;
import com.github.tomakehurst.wiremock.verification.notmatched.NotMatchedRenderer;
import com.github.tomakehurst.wiremock.verification.notmatched.PlainTextStubNotMatchedRenderer;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import wiremock.com.google.common.annotations.VisibleForTesting;
import wiremock.com.google.common.base.Optional;
import wiremock.com.google.common.base.Strings;
import wiremock.com.google.common.collect.ImmutableList;
import wiremock.com.google.common.collect.ImmutableMap;
import wiremock.com.google.common.collect.ImmutableSet;
import wiremock.com.google.common.collect.Iterators;
import wiremock.com.google.common.collect.Maps;
import wiremock.com.google.common.collect.UnmodifiableIterator;
import wiremock.com.google.common.io.Resources;

public class CommandLineOptions
implements Options {
    private static final String HELP = "help";
    private static final String RECORD_MAPPINGS = "record-mappings";
    private static final String MATCH_HEADERS = "match-headers";
    private static final String PROXY_ALL = "proxy-all";
    private static final String PRESERVE_HOST_HEADER = "preserve-host-header";
    private static final String PROXY_VIA = "proxy-via";
    private static final String PORT = "port";
    private static final String DISABLE_HTTP = "disable-http";
    private static final String BIND_ADDRESS = "bind-address";
    private static final String HTTPS_PORT = "https-port";
    private static final String HTTPS_KEYSTORE = "https-keystore";
    private static final String HTTPS_KEYSTORE_PASSWORD = "keystore-password";
    private static final String HTTPS_TRUSTSTORE = "https-truststore";
    private static final String HTTPS_TRUSTSTORE_PASSWORD = "truststore-password";
    private static final String REQUIRE_CLIENT_CERT = "https-require-client-cert";
    private static final String VERBOSE = "verbose";
    private static final String ENABLE_BROWSER_PROXYING = "enable-browser-proxying";
    private static final String DISABLE_BANNER = "disable-banner";
    private static final String DISABLE_REQUEST_JOURNAL = "no-request-journal";
    private static final String EXTENSIONS = "extensions";
    private static final String MAX_ENTRIES_REQUEST_JOURNAL = "max-request-journal-entries";
    private static final String JETTY_ACCEPTOR_THREAD_COUNT = "jetty-acceptor-threads";
    private static final String PRINT_ALL_NETWORK_TRAFFIC = "print-all-network-traffic";
    private static final String JETTY_ACCEPT_QUEUE_SIZE = "jetty-accept-queue-size";
    private static final String JETTY_HEADER_BUFFER_SIZE = "jetty-header-buffer-size";
    private static final String JETTY_STOP_TIMEOUT = "jetty-stop-timeout";
    private static final String ROOT_DIR = "root-dir";
    private static final String CONTAINER_THREADS = "container-threads";
    private static final String GLOBAL_RESPONSE_TEMPLATING = "global-response-templating";
    private static final String LOCAL_RESPONSE_TEMPLATING = "local-response-templating";
    private static final String ADMIN_API_BASIC_AUTH = "admin-api-basic-auth";
    private static final String ADMIN_API_REQUIRE_HTTPS = "admin-api-require-https";
    private static final String ASYNCHRONOUS_RESPONSE_ENABLED = "async-response-enabled";
    private static final String ASYNCHRONOUS_RESPONSE_THREADS = "async-response-threads";
    private static final String USE_CHUNKED_ENCODING = "use-chunked-encoding";
    private static final String MAX_TEMPLATE_CACHE_ENTRIES = "max-template-cache-entries";
    private static final String PERMITTED_SYSTEM_KEYS = "permitted-system-keys";
    private static final String DISABLE_GZIP = "disable-gzip";
    private static final String DISABLE_REQUEST_LOGGING = "disable-request-logging";
    private final OptionSet optionSet;
    private final FileSource fileSource;
    private final MappingsSource mappingsSource;
    private String helpText;
    private Integer actualHttpPort;
    private Integer actualHttpsPort;

    public CommandLineOptions(String ... args) {
        OptionParser optionParser = new OptionParser();
        optionParser.accepts(PORT, "The port number for the server to listen on (default: 8080). 0 for dynamic port selection.").withRequiredArg();
        optionParser.accepts(DISABLE_HTTP, "Disable the default HTTP listener.");
        optionParser.accepts(HTTPS_PORT, "If this option is present WireMock will enable HTTPS on the specified port").withRequiredArg();
        optionParser.accepts(BIND_ADDRESS, "The IP to listen connections").withRequiredArg();
        optionParser.accepts(CONTAINER_THREADS, "The number of container threads").withRequiredArg();
        optionParser.accepts(REQUIRE_CLIENT_CERT, "Make the server require a trusted client certificate to enable a connection");
        optionParser.accepts(HTTPS_TRUSTSTORE_PASSWORD, "Password for the trust store").withRequiredArg();
        optionParser.accepts(HTTPS_TRUSTSTORE, "Path to an alternative truststore for HTTPS client certificates. Must have a password of \"password\".").requiredIf(REQUIRE_CLIENT_CERT, new String[0]).withRequiredArg();
        optionParser.accepts(HTTPS_KEYSTORE_PASSWORD, "Password for the alternative keystore.").withRequiredArg().defaultsTo("password", (String[])new String[0]);
        optionParser.accepts(HTTPS_KEYSTORE, "Path to an alternative keystore for HTTPS. Password is assumed to be \"password\" if not specified.").requiredIf(HTTPS_TRUSTSTORE, new String[0]).requiredIf(HTTPS_KEYSTORE_PASSWORD, new String[0]).withRequiredArg().defaultsTo(Resources.getResource("keystore").toString(), (String[])new String[0]);
        optionParser.accepts(PROXY_ALL, "Will create a proxy mapping for /* to the specified URL").withRequiredArg();
        optionParser.accepts(PRESERVE_HOST_HEADER, "Will transfer the original host header from the client to the proxied service");
        optionParser.accepts(PROXY_VIA, "Specifies a proxy server to use when routing proxy mapped requests").withRequiredArg();
        optionParser.accepts(RECORD_MAPPINGS, "Enable recording of all (non-admin) requests as mapping files");
        optionParser.accepts(MATCH_HEADERS, "Enable request header matching when recording through a proxy").withRequiredArg();
        optionParser.accepts(ROOT_DIR, "Specifies path for storing recordings (parent for mappings and __files folders)").withRequiredArg().defaultsTo(".", (String[])new String[0]);
        optionParser.accepts(VERBOSE, "Enable verbose logging to stdout");
        optionParser.accepts(ENABLE_BROWSER_PROXYING, "Allow wiremock to be set as a browser's proxy server");
        optionParser.accepts(DISABLE_REQUEST_JOURNAL, "Disable the request journal (to avoid heap growth when running wiremock for long periods without reset)");
        optionParser.accepts(DISABLE_BANNER, "Disable print banner logo");
        optionParser.accepts(EXTENSIONS, "Matching and/or response transformer extension class names, comma separated.").withRequiredArg();
        optionParser.accepts(MAX_ENTRIES_REQUEST_JOURNAL, "Set maximum number of entries in request journal (if enabled) to discard old entries if the log becomes too large. Default: no discard").withRequiredArg();
        optionParser.accepts(JETTY_ACCEPTOR_THREAD_COUNT, "Number of Jetty acceptor threads").withRequiredArg();
        optionParser.accepts(JETTY_ACCEPT_QUEUE_SIZE, "The size of Jetty's accept queue size").withRequiredArg();
        optionParser.accepts(JETTY_HEADER_BUFFER_SIZE, "The size of Jetty's buffer for request headers").withRequiredArg();
        optionParser.accepts(JETTY_STOP_TIMEOUT, "Timeout in milliseconds for Jetty to stop").withRequiredArg();
        optionParser.accepts(PRINT_ALL_NETWORK_TRAFFIC, "Print all raw incoming and outgoing network traffic to console");
        optionParser.accepts(GLOBAL_RESPONSE_TEMPLATING, "Preprocess all responses with Handlebars templates");
        optionParser.accepts(LOCAL_RESPONSE_TEMPLATING, "Preprocess selected responses with Handlebars templates");
        optionParser.accepts(ADMIN_API_BASIC_AUTH, "Require HTTP Basic authentication for admin API calls with the supplied credentials in username:password format").withRequiredArg();
        optionParser.accepts(ADMIN_API_REQUIRE_HTTPS, "Require HTTPS to be used to access the admin API");
        optionParser.accepts(ASYNCHRONOUS_RESPONSE_ENABLED, "Enable asynchronous response").withRequiredArg().defaultsTo("false", (String[])new String[0]);
        optionParser.accepts(ASYNCHRONOUS_RESPONSE_THREADS, "Number of asynchronous response threads").withRequiredArg().defaultsTo("10", (String[])new String[0]);
        optionParser.accepts(USE_CHUNKED_ENCODING, "Whether to use Transfer-Encoding: chunked in responses. Can be set to always, never or body_file.").withRequiredArg().defaultsTo("always", (String[])new String[0]);
        optionParser.accepts(MAX_TEMPLATE_CACHE_ENTRIES, "The maximum number of response template fragments that can be cached. Only has any effect when templating is enabled. Defaults to no limit.").withOptionalArg();
        optionParser.accepts(PERMITTED_SYSTEM_KEYS, "A list of case-insensitive regular expressions for names of permitted system properties and environment vars. Only has any effect when templating is enabled. Defaults to no limit.").withOptionalArg().ofType(String.class).withValuesSeparatedBy(",");
        optionParser.accepts(DISABLE_GZIP, "Disable gzipping of request and response bodies");
        optionParser.accepts(DISABLE_REQUEST_LOGGING, "Disable logging of stub requests and responses to the notifier. Useful when performance testing.");
        optionParser.accepts(HELP, "Print this message");
        this.optionSet = optionParser.parse(args);
        this.validate();
        this.captureHelpTextIfRequested(optionParser);
        this.fileSource = new SingleRootFileSource((String)this.optionSet.valueOf(ROOT_DIR));
        this.mappingsSource = new JsonFileMappingsSource(this.fileSource.child("mappings"));
        this.actualHttpPort = null;
    }

    private void validate() {
        if (this.optionSet.has(PORT) && this.optionSet.has(DISABLE_HTTP)) {
            throw new IllegalArgumentException("The HTTP listener can't have a port set and be disabled at the same time");
        }
        if (!this.optionSet.has(HTTPS_PORT) && this.optionSet.has(DISABLE_HTTP)) {
            throw new IllegalArgumentException("HTTPS must be enabled if HTTP is not.");
        }
        if (this.optionSet.has(HTTPS_KEYSTORE) && !this.optionSet.has(HTTPS_PORT)) {
            throw new IllegalArgumentException("HTTPS port number must be specified if specifying the keystore path");
        }
        if (this.optionSet.has(RECORD_MAPPINGS) && this.optionSet.has(DISABLE_REQUEST_JOURNAL)) {
            throw new IllegalArgumentException("Request journal must be enabled to record stubs");
        }
    }

    private void captureHelpTextIfRequested(OptionParser optionParser) {
        if (this.optionSet.has(HELP)) {
            StringWriter out = new StringWriter();
            try {
                optionParser.printHelpOn(out);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.helpText = out.toString();
        }
    }

    public boolean verboseLoggingEnabled() {
        return this.optionSet.has(VERBOSE);
    }

    public boolean recordMappingsEnabled() {
        return this.optionSet.has(RECORD_MAPPINGS);
    }

    @Override
    public List<CaseInsensitiveKey> matchingHeaders() {
        if (this.optionSet.hasArgument(MATCH_HEADERS)) {
            String headerSpec = (String)this.optionSet.valueOf(MATCH_HEADERS);
            UnmodifiableIterator<String> headerKeys = Iterators.forArray(headerSpec.split(","));
            return ImmutableList.copyOf(Iterators.transform(headerKeys, CaseInsensitiveKey.TO_CASE_INSENSITIVE_KEYS));
        }
        return Collections.emptyList();
    }

    @Override
    public HttpServerFactory httpServerFactory() {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> cls = loader.loadClass("com.github.tomakehurst.wiremock.jetty9.JettyHttpServerFactory");
            return (HttpServerFactory)cls.newInstance();
        }
        catch (Exception e) {
            return (HttpServerFactory)Exceptions.throwUnchecked(e, null);
        }
    }

    @Override
    public ThreadPoolFactory threadPoolFactory() {
        return new QueuedThreadPoolFactory();
    }

    private boolean specifiesPortNumber() {
        return this.optionSet.has(PORT);
    }

    @Override
    public int portNumber() {
        if (this.specifiesPortNumber()) {
            return Integer.parseInt((String)this.optionSet.valueOf(PORT));
        }
        return 8080;
    }

    @Override
    public boolean getHttpDisabled() {
        return this.optionSet.has(DISABLE_HTTP);
    }

    public void setActualHttpPort(int port) {
        this.actualHttpPort = port;
    }

    public void setActualHttpsPort(int port) {
        this.actualHttpsPort = port;
    }

    @Override
    public String bindAddress() {
        if (this.optionSet.has(BIND_ADDRESS)) {
            return (String)this.optionSet.valueOf(BIND_ADDRESS);
        }
        return "0.0.0.0";
    }

    @Override
    public HttpsSettings httpsSettings() {
        return new HttpsSettings.Builder().port(this.httpsPortNumber()).keyStorePath((String)this.optionSet.valueOf(HTTPS_KEYSTORE)).keyStorePassword((String)this.optionSet.valueOf(HTTPS_KEYSTORE_PASSWORD)).trustStorePath((String)this.optionSet.valueOf(HTTPS_TRUSTSTORE)).trustStorePassword((String)this.optionSet.valueOf(HTTPS_TRUSTSTORE_PASSWORD)).needClientAuth(this.optionSet.has(REQUIRE_CLIENT_CERT)).build();
    }

    @Override
    public JettySettings jettySettings() {
        JettySettings.Builder builder = JettySettings.Builder.aJettySettings();
        if (this.optionSet.hasArgument(JETTY_ACCEPTOR_THREAD_COUNT)) {
            builder = builder.withAcceptors(Integer.parseInt((String)this.optionSet.valueOf(JETTY_ACCEPTOR_THREAD_COUNT)));
        }
        if (this.optionSet.hasArgument(JETTY_ACCEPT_QUEUE_SIZE)) {
            builder = builder.withAcceptQueueSize(Integer.parseInt((String)this.optionSet.valueOf(JETTY_ACCEPT_QUEUE_SIZE)));
        }
        if (this.optionSet.hasArgument(JETTY_HEADER_BUFFER_SIZE)) {
            builder = builder.withRequestHeaderSize(Integer.parseInt((String)this.optionSet.valueOf(JETTY_HEADER_BUFFER_SIZE)));
        }
        if (this.optionSet.hasArgument(JETTY_STOP_TIMEOUT)) {
            builder = builder.withStopTimeout(Long.parseLong((String)this.optionSet.valueOf(JETTY_STOP_TIMEOUT)));
        }
        return builder.build();
    }

    private int httpsPortNumber() {
        return this.optionSet.has(HTTPS_PORT) ? Integer.parseInt((String)this.optionSet.valueOf(HTTPS_PORT)) : -1;
    }

    public boolean help() {
        return this.optionSet.has(HELP);
    }

    public String helpText() {
        return this.helpText;
    }

    public boolean specifiesProxyUrl() {
        return this.optionSet.has(PROXY_ALL);
    }

    public String proxyUrl() {
        return (String)this.optionSet.valueOf(PROXY_ALL);
    }

    @Override
    public boolean shouldPreserveHostHeader() {
        return this.optionSet.has(PRESERVE_HOST_HEADER);
    }

    @Override
    public String proxyHostHeader() {
        return this.optionSet.hasArgument(PROXY_ALL) ? URI.create((String)this.optionSet.valueOf(PROXY_ALL)).getAuthority() : null;
    }

    @Override
    public <T extends Extension> Map<String, T> extensionsOfType(Class<T> extensionType) {
        ResponseTemplateTransformer transformer;
        ImmutableMap.Builder<String, Extension> builder = ImmutableMap.builder();
        if (this.optionSet.has(EXTENSIONS)) {
            String classNames = (String)this.optionSet.valueOf(EXTENSIONS);
            builder.putAll(Maps.filterEntries(ExtensionLoader.load(classNames.split(",")), ExtensionLoader.valueAssignableFrom(extensionType)));
        }
        if (this.optionSet.has(GLOBAL_RESPONSE_TEMPLATING) && ResponseDefinitionTransformer.class.isAssignableFrom(extensionType)) {
            transformer = ResponseTemplateTransformer.builder().global(true).maxCacheEntries(this.getMaxTemplateCacheEntries()).permittedSystemKeys(this.getPermittedSystemKeys()).build();
            builder.put(transformer.getName(), transformer);
        } else if (this.optionSet.has(LOCAL_RESPONSE_TEMPLATING) && ResponseDefinitionTransformer.class.isAssignableFrom(extensionType)) {
            transformer = ResponseTemplateTransformer.builder().global(false).maxCacheEntries(this.getMaxTemplateCacheEntries()).permittedSystemKeys(this.getPermittedSystemKeys()).build();
            builder.put(transformer.getName(), transformer);
        }
        return builder.build();
    }

    @Override
    public WiremockNetworkTrafficListener networkTrafficListener() {
        if (this.optionSet.has(PRINT_ALL_NETWORK_TRAFFIC)) {
            return new ConsoleNotifyingWiremockNetworkTrafficListener();
        }
        return new DoNothingWiremockNetworkTrafficListener();
    }

    @Override
    public Authenticator getAdminAuthenticator() {
        if (this.optionSet.has(ADMIN_API_BASIC_AUTH)) {
            String[] parts = ((String)this.optionSet.valueOf(ADMIN_API_BASIC_AUTH)).split(":");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Admin API credentials must be in the format username:password");
            }
            return new BasicAuthenticator(parts[0], parts[1]);
        }
        return new NoAuthenticator();
    }

    @Override
    public boolean getHttpsRequiredForAdminApi() {
        return this.optionSet.has(ADMIN_API_REQUIRE_HTTPS);
    }

    @Override
    public NotMatchedRenderer getNotMatchedRenderer() {
        return new PlainTextStubNotMatchedRenderer();
    }

    @Override
    public boolean browserProxyingEnabled() {
        return this.optionSet.has(ENABLE_BROWSER_PROXYING);
    }

    @Override
    public ProxySettings proxyVia() {
        if (this.optionSet.has(PROXY_VIA)) {
            String proxyVia = (String)this.optionSet.valueOf(PROXY_VIA);
            return ProxySettings.fromString(proxyVia);
        }
        return ProxySettings.NO_PROXY;
    }

    @Override
    public FileSource filesRoot() {
        return this.fileSource;
    }

    @Override
    public MappingsLoader mappingsLoader() {
        return this.mappingsSource;
    }

    @Override
    public MappingsSaver mappingsSaver() {
        return this.mappingsSource;
    }

    @Override
    public Notifier notifier() {
        return new ConsoleNotifier(this.verboseLoggingEnabled());
    }

    @Override
    public boolean requestJournalDisabled() {
        return this.optionSet.has(DISABLE_REQUEST_JOURNAL);
    }

    public boolean bannerDisabled() {
        return this.optionSet.has(DISABLE_BANNER);
    }

    private boolean specifiesMaxRequestJournalEntries() {
        return this.optionSet.has(MAX_ENTRIES_REQUEST_JOURNAL);
    }

    @Override
    public Optional<Integer> maxRequestJournalEntries() {
        if (this.specifiesMaxRequestJournalEntries()) {
            return Optional.of(Integer.parseInt((String)this.optionSet.valueOf(MAX_ENTRIES_REQUEST_JOURNAL)));
        }
        return Optional.absent();
    }

    @Override
    public int containerThreads() {
        if (this.optionSet.has(CONTAINER_THREADS)) {
            return Integer.parseInt((String)this.optionSet.valueOf(CONTAINER_THREADS));
        }
        return 14;
    }

    public String toString() {
        ImmutableMap.Builder<String, Object> builder = ImmutableMap.builder();
        if (this.actualHttpPort != null) {
            builder.put(PORT, this.actualHttpPort);
        }
        if (this.actualHttpsPort != null) {
            builder.put(HTTPS_PORT, this.actualHttpsPort);
        }
        if (this.httpsSettings().enabled()) {
            builder.put(HTTPS_KEYSTORE, this.nullToString(this.httpsSettings().keyStorePath()));
        }
        if (this.proxyVia() != ProxySettings.NO_PROXY) {
            builder.put(PROXY_VIA, this.proxyVia());
        }
        if (this.proxyUrl() != null) {
            builder.put(PROXY_ALL, this.nullToString(this.proxyUrl())).put(PRESERVE_HOST_HEADER, (String)((Object)Boolean.valueOf(this.shouldPreserveHostHeader())));
        }
        builder.put(ENABLE_BROWSER_PROXYING, this.browserProxyingEnabled());
        builder.put(DISABLE_BANNER, this.bannerDisabled());
        if (this.recordMappingsEnabled()) {
            builder.put(RECORD_MAPPINGS, this.recordMappingsEnabled()).put(MATCH_HEADERS, (Boolean)((Object)this.matchingHeaders()));
        }
        builder.put(DISABLE_REQUEST_JOURNAL, this.requestJournalDisabled()).put(VERBOSE, this.verboseLoggingEnabled());
        if (this.jettySettings().getAcceptQueueSize().isPresent()) {
            builder.put(JETTY_ACCEPT_QUEUE_SIZE, this.jettySettings().getAcceptQueueSize().get());
        }
        if (this.jettySettings().getAcceptors().isPresent()) {
            builder.put(JETTY_ACCEPTOR_THREAD_COUNT, this.jettySettings().getAcceptors().get());
        }
        if (this.jettySettings().getRequestHeaderSize().isPresent()) {
            builder.put(JETTY_HEADER_BUFFER_SIZE, this.jettySettings().getRequestHeaderSize().get());
        }
        if (!(this.getAdminAuthenticator() instanceof NoAuthenticator)) {
            builder.put(ADMIN_API_BASIC_AUTH, "enabled");
        }
        if (this.getHttpsRequiredForAdminApi()) {
            builder.put(ADMIN_API_REQUIRE_HTTPS, "true");
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry param : builder.build().entrySet()) {
            int paddingLength = 29 - ((String)param.getKey()).length();
            sb.append((String)param.getKey()).append(":").append(Strings.repeat(" ", paddingLength)).append(this.nullToString(param.getValue())).append("\n");
        }
        return sb.toString();
    }

    private String nullToString(Object value) {
        if (value == null) {
            return "(null)";
        }
        return value.toString();
    }

    @Override
    public AsynchronousResponseSettings getAsynchronousResponseSettings() {
        return new AsynchronousResponseSettings(this.isAsynchronousResponseEnabled(), this.getAsynchronousResponseThreads());
    }

    @Override
    public Options.ChunkedEncodingPolicy getChunkedEncodingPolicy() {
        return this.optionSet.has(USE_CHUNKED_ENCODING) ? Options.ChunkedEncodingPolicy.valueOf(this.optionSet.valueOf(USE_CHUNKED_ENCODING).toString().toUpperCase()) : Options.ChunkedEncodingPolicy.ALWAYS;
    }

    @Override
    public boolean getGzipDisabled() {
        return this.optionSet.has(DISABLE_GZIP);
    }

    @Override
    public boolean getStubRequestLoggingDisabled() {
        return this.optionSet.has(DISABLE_REQUEST_LOGGING);
    }

    private Long getMaxTemplateCacheEntries() {
        return this.optionSet.has(MAX_TEMPLATE_CACHE_ENTRIES) ? Long.valueOf(this.optionSet.valueOf(MAX_TEMPLATE_CACHE_ENTRIES).toString()) : null;
    }

    @VisibleForTesting
    public Set<String> getPermittedSystemKeys() {
        return this.optionSet.has(PERMITTED_SYSTEM_KEYS) ? ImmutableSet.copyOf(this.optionSet.valuesOf(PERMITTED_SYSTEM_KEYS)) : Collections.emptySet();
    }

    private boolean isAsynchronousResponseEnabled() {
        return this.optionSet.has(ASYNCHRONOUS_RESPONSE_ENABLED) ? Boolean.valueOf((String)this.optionSet.valueOf(ASYNCHRONOUS_RESPONSE_ENABLED)) : false;
    }

    private int getAsynchronousResponseThreads() {
        return Integer.valueOf((String)this.optionSet.valueOf(ASYNCHRONOUS_RESPONSE_THREADS));
    }
}

