/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification;

import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestListener;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.stubbing.ServedStub;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.RequestJournal;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import wiremock.com.google.common.base.Function;
import wiremock.com.google.common.base.Optional;
import wiremock.com.google.common.base.Predicate;
import wiremock.com.google.common.collect.ImmutableList;
import wiremock.com.google.common.collect.Iterables;

public class InMemoryRequestJournal
implements RequestListener,
RequestJournal {
    private final Queue<ServedStub> servedStubs = new ConcurrentLinkedQueue<ServedStub>();
    private final Optional<Integer> maxEntries;

    public InMemoryRequestJournal(Optional<Integer> maxEntries) {
        if (maxEntries.isPresent() && maxEntries.get() < 0) {
            throw new IllegalArgumentException("Maximum number of entries of journal must be greater than zero");
        }
        this.maxEntries = maxEntries;
    }

    @Override
    public int countRequestsMatching(RequestPattern requestPattern) {
        return Iterables.size(Iterables.filter(this.getRequests(), RequestPattern.thatMatch(requestPattern)));
    }

    @Override
    public List<LoggedRequest> getRequestsMatching(RequestPattern requestPattern) {
        return ImmutableList.copyOf(Iterables.filter(this.getRequests(), RequestPattern.thatMatch(requestPattern)));
    }

    private Predicate<Request> matchedBy(final RequestPattern requestPattern) {
        return new Predicate<Request>(){

            @Override
            public boolean apply(Request input) {
                return requestPattern.isMatchedBy(input, Collections.emptyMap());
            }
        };
    }

    @Override
    public void requestReceived(Request request, Response response) {
        this.servedStubs.add(ServedStub.exactMatch(LoggedRequest.createFrom(request), null));
        this.removeOldEntries();
    }

    @Override
    public void requestReceived(ServedStub servedStub) {
        this.servedStubs.add(servedStub);
        this.removeOldEntries();
    }

    @Override
    public List<ServedStub> getAllServedStubs() {
        return ImmutableList.copyOf(this.servedStubs);
    }

    @Override
    public void reset() {
        this.servedStubs.clear();
    }

    private Iterable<LoggedRequest> getRequests() {
        return Iterables.transform(this.servedStubs, new Function<ServedStub, LoggedRequest>(){

            @Override
            public LoggedRequest apply(ServedStub input) {
                return input.getRequest();
            }
        });
    }

    private void removeOldEntries() {
        if (this.maxEntries.isPresent()) {
            while (this.servedStubs.size() > this.maxEntries.get()) {
                this.servedStubs.poll();
            }
        }
    }
}

