/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock;

import com.github.tomakehurst.wiremock.client.LocalMappingBuilder;
import com.github.tomakehurst.wiremock.client.RemoteMappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.FatalStartupException;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.common.ProxySettings;
import com.github.tomakehurst.wiremock.core.Admin;
import com.github.tomakehurst.wiremock.core.Container;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockApp;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.ResponseDefinitionTransformer;
import com.github.tomakehurst.wiremock.extension.ResponseTransformer;
import com.github.tomakehurst.wiremock.global.GlobalSettings;
import com.github.tomakehurst.wiremock.global.GlobalSettingsHolder;
import com.github.tomakehurst.wiremock.http.AdminRequestHandler;
import com.github.tomakehurst.wiremock.http.BasicResponseRenderer;
import com.github.tomakehurst.wiremock.http.HttpServer;
import com.github.tomakehurst.wiremock.http.HttpServerFactory;
import com.github.tomakehurst.wiremock.http.ProxyResponseRenderer;
import com.github.tomakehurst.wiremock.http.RequestListener;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.http.StubResponseRenderer;
import com.github.tomakehurst.wiremock.junit.LocalStubbing;
import com.github.tomakehurst.wiremock.matching.LocalRequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.RequestMatcherExtension;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.standalone.JsonFileMappingsSource;
import com.github.tomakehurst.wiremock.standalone.MappingsLoader;
import com.github.tomakehurst.wiremock.stubbing.ListStubMappingsResult;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.stubbing.StubMappingJsonRecorder;
import com.github.tomakehurst.wiremock.verification.FindNearMissesResult;
import com.github.tomakehurst.wiremock.verification.FindRequestsResult;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.NearMiss;
import com.github.tomakehurst.wiremock.verification.VerificationResult;
import java.util.List;
import wiremock.com.google.common.base.Preconditions;
import wiremock.com.google.common.collect.ImmutableList;

public class WireMockServer
implements Container,
LocalStubbing,
Admin {
    public static final String FILES_ROOT = "__files";
    public static final String MAPPINGS_ROOT = "mappings";
    private final WireMockApp wireMockApp;
    private final StubRequestHandler stubRequestHandler;
    private final HttpServer httpServer;
    private final FileSource fileSource;
    private final Notifier notifier;
    private final Options options;
    protected final WireMock client;

    public WireMockServer(Options options) {
        this.options = options;
        this.fileSource = options.filesRoot();
        this.notifier = options.notifier();
        JsonFileMappingsSource mappingsSource = new JsonFileMappingsSource(this.fileSource.child(MAPPINGS_ROOT));
        this.wireMockApp = new WireMockApp(options.browserProxyingEnabled(), mappingsSource, mappingsSource, options.requestJournalDisabled(), options.maxRequestJournalEntries(), options.extensionsOfType(ResponseDefinitionTransformer.class), options.extensionsOfType(RequestMatcherExtension.class), this.fileSource, this);
        AdminRequestHandler adminRequestHandler = new AdminRequestHandler(this.wireMockApp, new BasicResponseRenderer());
        this.stubRequestHandler = new StubRequestHandler(this.wireMockApp, new StubResponseRenderer(this.fileSource.child(FILES_ROOT), this.wireMockApp.getGlobalSettingsHolder(), new ProxyResponseRenderer(options.proxyVia(), options.httpsSettings().trustStore(), options.shouldPreserveHostHeader(), options.proxyHostHeader()), ImmutableList.copyOf(options.extensionsOfType(ResponseTransformer.class).values())));
        HttpServerFactory httpServerFactory = options.httpServerFactory();
        this.httpServer = httpServerFactory.buildHttpServer(options, adminRequestHandler, this.stubRequestHandler);
        this.client = new WireMock(this.wireMockApp);
    }

    public WireMockServer(int port, Integer httpsPort, FileSource fileSource, boolean enableBrowserProxying, ProxySettings proxySettings, Notifier notifier) {
        this(WireMockConfiguration.wireMockConfig().port(port).httpsPort(httpsPort).fileSource(fileSource).enableBrowserProxying(enableBrowserProxying).proxyVia(proxySettings).notifier(notifier));
    }

    public WireMockServer(int port, FileSource fileSource, boolean enableBrowserProxying, ProxySettings proxySettings) {
        this(WireMockConfiguration.wireMockConfig().port(port).fileSource(fileSource).enableBrowserProxying(enableBrowserProxying).proxyVia(proxySettings));
    }

    public WireMockServer(int port, FileSource fileSource, boolean enableBrowserProxying) {
        this(WireMockConfiguration.wireMockConfig().port(port).fileSource(fileSource).enableBrowserProxying(enableBrowserProxying));
    }

    public WireMockServer(int port) {
        this(WireMockConfiguration.wireMockConfig().port(port));
    }

    public WireMockServer(int port, Integer httpsPort) {
        this(WireMockConfiguration.wireMockConfig().port(port).httpsPort(httpsPort));
    }

    public WireMockServer() {
        this(WireMockConfiguration.wireMockConfig());
    }

    public void loadMappingsUsing(MappingsLoader mappingsLoader) {
        this.wireMockApp.loadMappingsUsing(mappingsLoader);
    }

    public GlobalSettingsHolder getGlobalSettingsHolder() {
        return this.wireMockApp.getGlobalSettingsHolder();
    }

    public void addMockServiceRequestListener(RequestListener listener) {
        this.stubRequestHandler.addRequestListener(listener);
    }

    public void enableRecordMappings(FileSource mappingsFileSource, FileSource filesFileSource) {
        this.addMockServiceRequestListener(new StubMappingJsonRecorder(mappingsFileSource, filesFileSource, this.wireMockApp, this.options.matchingHeaders()));
        this.notifier.info("Recording mappings to " + mappingsFileSource.getPath());
    }

    public void stop() {
        this.httpServer.stop();
    }

    public void start() {
        try {
            this.httpServer.start();
        }
        catch (Exception e) {
            throw new FatalStartupException(e);
        }
    }

    @Override
    public void shutdown() {
        final WireMockServer server = this;
        Thread shutdownThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                server.stop();
            }
        });
        shutdownThread.start();
    }

    @Override
    public int port() {
        Preconditions.checkState(this.isRunning(), "Not listening on HTTP port. The WireMock server is most likely stopped");
        return this.httpServer.port();
    }

    public int httpsPort() {
        Preconditions.checkState(this.isRunning() && this.options.httpsSettings().enabled(), "Not listening on HTTPS port. Either HTTPS is not enabled or the WireMock server is stopped.");
        return this.httpServer.httpsPort();
    }

    public boolean isRunning() {
        return this.httpServer.isRunning();
    }

    @Override
    public void givenThat(RemoteMappingBuilder mappingBuilder) {
        this.client.register(mappingBuilder);
    }

    @Override
    public void stubFor(RemoteMappingBuilder mappingBuilder) {
        this.givenThat(mappingBuilder);
    }

    @Override
    public void editStub(RemoteMappingBuilder mappingBuilder) {
        this.client.editStubMapping(mappingBuilder);
    }

    @Override
    public void givenThat(LocalMappingBuilder mappingBuilder) {
        this.stubFor(mappingBuilder);
    }

    @Override
    public void stubFor(LocalMappingBuilder mappingBuilder) {
        this.client.register(mappingBuilder.build());
    }

    @Override
    public void verify(RequestPatternBuilder requestPatternBuilder) {
        this.client.verifyThat(requestPatternBuilder);
    }

    @Override
    public void verify(int count, RequestPatternBuilder requestPatternBuilder) {
        this.client.verifyThat(count, requestPatternBuilder);
    }

    @Override
    public void verify(LocalRequestPatternBuilder requestPatternBuilder) {
        this.verify(requestPatternBuilder.getUnderlyingBuilder());
    }

    @Override
    public void verify(int count, LocalRequestPatternBuilder requestPatternBuilder) {
        this.verify(count, requestPatternBuilder.getUnderlyingBuilder());
    }

    @Override
    public List<LoggedRequest> findAll(RequestPatternBuilder requestPatternBuilder) {
        return this.client.find(requestPatternBuilder);
    }

    @Override
    public void setGlobalFixedDelay(int milliseconds) {
        this.client.setGlobalFixedDelayVariable(milliseconds);
    }

    @Override
    public List<LoggedRequest> findAllUnmatchedRequests() {
        return this.client.findAllUnmatchedRequests();
    }

    @Override
    public List<NearMiss> findNearMissesForAllUnmatchedRequests() {
        return this.client.findNearMissesForAllUnmatchedRequests();
    }

    @Override
    public List<NearMiss> findAllNearMissesFor(RequestPatternBuilder requestPatternBuilder) {
        return this.client.findAllNearMissesFor(requestPatternBuilder);
    }

    @Override
    public List<NearMiss> findNearMissesFor(LoggedRequest loggedRequest) {
        return this.client.findTopNearMissesFor(loggedRequest);
    }

    @Override
    public void addStubMapping(StubMapping stubMapping) {
        this.wireMockApp.addStubMapping(stubMapping);
    }

    @Override
    public void editStubMapping(StubMapping stubMapping) {
        this.wireMockApp.editStubMapping(stubMapping);
    }

    @Override
    public ListStubMappingsResult listAllStubMappings() {
        return this.wireMockApp.listAllStubMappings();
    }

    @Override
    public void saveMappings() {
        this.wireMockApp.saveMappings();
    }

    @Override
    public void resetMappings() {
        this.wireMockApp.resetMappings();
    }

    @Override
    public void resetRequests() {
        this.wireMockApp.resetRequests();
    }

    @Override
    public void resetToDefaultMappings() {
        this.wireMockApp.resetToDefaultMappings();
    }

    @Override
    public void resetScenarios() {
        this.wireMockApp.resetScenarios();
    }

    @Override
    public VerificationResult countRequestsMatching(RequestPattern requestPattern) {
        return this.wireMockApp.countRequestsMatching(requestPattern);
    }

    @Override
    public FindRequestsResult findRequestsMatching(RequestPattern requestPattern) {
        return this.wireMockApp.findRequestsMatching(requestPattern);
    }

    @Override
    public FindRequestsResult findUnmatchedRequests() {
        return this.wireMockApp.findUnmatchedRequests();
    }

    @Override
    public void updateGlobalSettings(GlobalSettings newSettings) {
        this.wireMockApp.updateGlobalSettings(newSettings);
    }

    @Override
    public FindNearMissesResult findNearMissesForUnmatchedRequests() {
        return this.wireMockApp.findNearMissesForUnmatchedRequests();
    }

    @Override
    public FindNearMissesResult findTopNearMissesFor(LoggedRequest loggedRequest) {
        return this.wireMockApp.findTopNearMissesFor(loggedRequest);
    }

    @Override
    public FindNearMissesResult findTopNearMissesFor(RequestPattern requestPattern) {
        return this.wireMockApp.findTopNearMissesFor(requestPattern);
    }

    @Override
    public void shutdownServer() {
        this.shutdown();
    }
}

