/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.http.CaseInsensitiveKey;
import com.github.tomakehurst.wiremock.http.MultiValue;
import java.util.Arrays;
import java.util.Collection;
import wiremock.com.google.common.collect.ImmutableList;

public class HttpHeader
extends MultiValue {
    public HttpHeader(String key, String ... values) {
        super(key, Arrays.asList(values));
    }

    public HttpHeader(CaseInsensitiveKey key, Collection<String> values) {
        super(key.value(), ImmutableList.copyOf(values));
    }

    public HttpHeader(String key, Collection<String> values) {
        super(key, ImmutableList.copyOf(values));
    }

    public static HttpHeader httpHeader(CaseInsensitiveKey key, String ... values) {
        return new HttpHeader(key.value(), values);
    }

    public static HttpHeader httpHeader(String key, String ... values) {
        return new HttpHeader(key, values);
    }

    public static HttpHeader absent(String key) {
        return new HttpHeader(key, new String[0]);
    }

    public CaseInsensitiveKey caseInsensitiveKey() {
        return CaseInsensitiveKey.from(this.key);
    }

    public boolean keyEquals(String candidateKey) {
        return CaseInsensitiveKey.from(candidateKey).equals(this.caseInsensitiveKey());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpHeader that = (HttpHeader)o;
        if (this.key != null ? !this.key.toLowerCase().equals(that.key.toLowerCase()) : that.key != null) {
            return false;
        }
        return !(this.values != null ? !this.values.equals(that.values) : that.values != null);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.toLowerCase().hashCode() : 0;
        result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
        return result;
    }
}

