/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.tomakehurst.wiremock.common.DateTimeUnit;
import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.matching.AbsentPattern;
import com.github.tomakehurst.wiremock.matching.AbstractDateTimePattern;
import com.github.tomakehurst.wiremock.matching.AfterDateTimePattern;
import com.github.tomakehurst.wiremock.matching.AnythingPattern;
import com.github.tomakehurst.wiremock.matching.BeforeDateTimePattern;
import com.github.tomakehurst.wiremock.matching.ContainsPattern;
import com.github.tomakehurst.wiremock.matching.EqualToDateTimePattern;
import com.github.tomakehurst.wiremock.matching.EqualToJsonPattern;
import com.github.tomakehurst.wiremock.matching.EqualToPattern;
import com.github.tomakehurst.wiremock.matching.EqualToXmlPattern;
import com.github.tomakehurst.wiremock.matching.LogicalAnd;
import com.github.tomakehurst.wiremock.matching.LogicalOr;
import com.github.tomakehurst.wiremock.matching.MatchesJsonPathPattern;
import com.github.tomakehurst.wiremock.matching.MatchesXPathPattern;
import com.github.tomakehurst.wiremock.matching.NegativeRegexPattern;
import com.github.tomakehurst.wiremock.matching.RegexPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xmlunit.diff.ComparisonType;

public class StringValuePatternJsonDeserializer
extends JsonDeserializer<StringValuePattern> {
    private static final Map<String, Class<? extends StringValuePattern>> PATTERNS = new ImmutableMap.Builder().put((Object)"equalTo", EqualToPattern.class).put((Object)"equalToJson", EqualToJsonPattern.class).put((Object)"matchesJsonPath", MatchesJsonPathPattern.class).put((Object)"equalToXml", EqualToXmlPattern.class).put((Object)"matchesXPath", MatchesXPathPattern.class).put((Object)"contains", ContainsPattern.class).put((Object)"matches", RegexPattern.class).put((Object)"doesNotMatch", NegativeRegexPattern.class).put((Object)"before", BeforeDateTimePattern.class).put((Object)"after", AfterDateTimePattern.class).put((Object)"equalToDateTime", EqualToDateTimePattern.class).put((Object)"anything", AnythingPattern.class).put((Object)"absent", AbsentPattern.class).put((Object)"and", LogicalAnd.class).put((Object)"or", LogicalOr.class).build();

    public StringValuePattern deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        JsonNode rootNode = (JsonNode)parser.readValueAsTree();
        return this.buildStringValuePattern(rootNode);
    }

    public StringValuePattern buildStringValuePattern(JsonNode rootNode) throws JsonMappingException {
        if (StringValuePatternJsonDeserializer.isAbsent(rootNode)) {
            return AbsentPattern.ABSENT;
        }
        Class<? extends StringValuePattern> patternClass = StringValuePatternJsonDeserializer.findPatternClass(rootNode);
        if (patternClass.equals(EqualToJsonPattern.class)) {
            return this.deserializeEqualToJson(rootNode);
        }
        if (patternClass.equals(EqualToXmlPattern.class)) {
            return this.deserializeEqualToXml(rootNode);
        }
        if (patternClass.equals(MatchesJsonPathPattern.class)) {
            return this.deserialiseMatchesJsonPathPattern(rootNode);
        }
        if (patternClass.equals(MatchesXPathPattern.class)) {
            return this.deserialiseMatchesXPathPattern(rootNode);
        }
        if (patternClass.equals(EqualToPattern.class)) {
            return this.deserializeEqualTo(rootNode);
        }
        if (AbstractDateTimePattern.class.isAssignableFrom(patternClass)) {
            Map.Entry<String, JsonNode> mainFieldEntry = StringValuePatternJsonDeserializer.findMainFieldEntry(rootNode);
            String matcherName = mainFieldEntry.getKey();
            return this.deserialiseDateTimePattern(rootNode, matcherName);
        }
        if (patternClass.equals(LogicalAnd.class)) {
            return this.deserializeAnd(rootNode);
        }
        if (patternClass.equals(LogicalOr.class)) {
            return this.deserializeOr(rootNode);
        }
        Map.Entry<String, JsonNode> mainFieldEntry = StringValuePatternJsonDeserializer.findMainFieldEntry(rootNode);
        if (!mainFieldEntry.getValue().isTextual()) {
            throw new JsonMappingException(mainFieldEntry.getKey() + " operand must be a non-null string");
        }
        String operand = mainFieldEntry.getValue().textValue();
        try {
            Constructor<? extends StringValuePattern> constructor = StringValuePatternJsonDeserializer.findConstructor(patternClass);
            return constructor.newInstance(operand);
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, StringValuePattern.class);
        }
    }

    private static Map.Entry<String, JsonNode> findMainFieldEntry(JsonNode rootNode) {
        return (Map.Entry)Iterators.find((Iterator)rootNode.fields(), (Predicate)new Predicate<Map.Entry<String, JsonNode>>(){

            public boolean apply(Map.Entry<String, JsonNode> input) {
                return PATTERNS.keySet().contains(input.getKey());
            }
        });
    }

    private EqualToPattern deserializeEqualTo(JsonNode rootNode) throws JsonMappingException {
        if (!rootNode.has("equalTo")) {
            throw new JsonMappingException(rootNode.toString() + " is not a valid match operation");
        }
        JsonNode equalToNode = rootNode.findValue("equalTo");
        if (!equalToNode.isTextual()) {
            throw new JsonMappingException("equalTo operand must be a non-null string");
        }
        String operand = equalToNode.textValue();
        Boolean ignoreCase = StringValuePatternJsonDeserializer.fromNullable(rootNode.findValue("caseInsensitive"));
        return new EqualToPattern(operand, ignoreCase);
    }

    private EqualToJsonPattern deserializeEqualToJson(JsonNode rootNode) throws JsonMappingException {
        if (!rootNode.has("equalToJson")) {
            throw new JsonMappingException(rootNode.toString() + " is not a valid match operation");
        }
        JsonNode operand = rootNode.findValue("equalToJson");
        Boolean ignoreArrayOrder = StringValuePatternJsonDeserializer.fromNullable(rootNode.findValue("ignoreArrayOrder"));
        Boolean ignoreExtraElements = StringValuePatternJsonDeserializer.fromNullable(rootNode.findValue("ignoreExtraElements"));
        if (operand.isTextual()) {
            return new EqualToJsonPattern(operand.textValue(), ignoreArrayOrder, ignoreExtraElements);
        }
        return new EqualToJsonPattern(operand, ignoreArrayOrder, ignoreExtraElements);
    }

    private EqualToXmlPattern deserializeEqualToXml(JsonNode rootNode) throws JsonMappingException {
        if (!rootNode.has("equalToXml")) {
            throw new JsonMappingException(rootNode.toString() + " is not a valid match operation");
        }
        JsonNode operand = rootNode.findValue("equalToXml");
        Boolean enablePlaceholders = StringValuePatternJsonDeserializer.fromNullable(rootNode.findValue("enablePlaceholders"));
        String placeholderOpeningDelimiterRegex = StringValuePatternJsonDeserializer.fromNullableTextNode(rootNode.findValue("placeholderOpeningDelimiterRegex"));
        String placeholderClosingDelimiterRegex = StringValuePatternJsonDeserializer.fromNullableTextNode(rootNode.findValue("placeholderClosingDelimiterRegex"));
        Set<ComparisonType> exemptedComparisons = StringValuePatternJsonDeserializer.comparisonTypeSetFromArray(rootNode.findValue("exemptedComparisons"));
        return new EqualToXmlPattern(operand.textValue(), enablePlaceholders, placeholderOpeningDelimiterRegex, placeholderClosingDelimiterRegex, exemptedComparisons);
    }

    private MatchesJsonPathPattern deserialiseMatchesJsonPathPattern(JsonNode rootNode) throws JsonMappingException {
        if (!rootNode.has("matchesJsonPath")) {
            throw new JsonMappingException(rootNode.toString() + " is not a valid match operation");
        }
        JsonNode outerPatternNode = rootNode.findValue("matchesJsonPath");
        if (outerPatternNode.isTextual()) {
            return new MatchesJsonPathPattern(outerPatternNode.textValue());
        }
        if (!outerPatternNode.has("expression")) {
            throw new JsonMappingException("expression is required in the advanced matchesJsonPath form");
        }
        String expression = outerPatternNode.findValue("expression").textValue();
        StringValuePattern valuePattern = this.buildStringValuePattern(outerPatternNode);
        return new MatchesJsonPathPattern(expression, valuePattern);
    }

    private MatchesXPathPattern deserialiseMatchesXPathPattern(JsonNode rootNode) throws JsonMappingException {
        if (!rootNode.has("matchesXPath")) {
            throw new JsonMappingException(rootNode.toString() + " is not a valid match operation");
        }
        JsonNode namespacesNode = rootNode.findValue("xPathNamespaces");
        Map<String, String> namespaces = namespacesNode != null ? StringValuePatternJsonDeserializer.toNamespaceMap(namespacesNode) : Collections.emptyMap();
        JsonNode outerPatternNode = rootNode.findValue("matchesXPath");
        if (outerPatternNode.isTextual()) {
            return new MatchesXPathPattern(outerPatternNode.textValue(), namespaces);
        }
        if (!outerPatternNode.has("expression")) {
            throw new JsonMappingException("expression is required in the advanced matchesXPath form");
        }
        String expression = outerPatternNode.findValue("expression").textValue();
        StringValuePattern valuePattern = this.buildStringValuePattern(outerPatternNode);
        return new MatchesXPathPattern(expression, namespaces, valuePattern);
    }

    private StringValuePattern deserialiseDateTimePattern(JsonNode rootNode, String matcherName) throws JsonMappingException {
        JsonNode dateTimeNode = rootNode.findValue(matcherName);
        JsonNode formatNode = rootNode.findValue("actualFormat");
        JsonNode truncateExpectedNode = rootNode.findValue("truncateExpected");
        JsonNode truncateActualNode = rootNode.findValue("truncateActual");
        JsonNode expectedOffsetAmountNode = rootNode.findValue("expectedOffset");
        JsonNode expectedOffsetUnitNode = rootNode.findValue("expectedOffsetUnit");
        switch (matcherName) {
            case "before": {
                return new BeforeDateTimePattern(dateTimeNode.textValue(), formatNode != null ? formatNode.textValue() : null, truncateExpectedNode != null ? truncateExpectedNode.textValue() : null, truncateActualNode != null ? truncateActualNode.textValue() : null, expectedOffsetAmountNode != null ? Integer.valueOf(expectedOffsetAmountNode.intValue()) : null, expectedOffsetUnitNode != null ? DateTimeUnit.valueOf(expectedOffsetUnitNode.textValue().toUpperCase()) : null);
            }
            case "after": {
                return new AfterDateTimePattern(dateTimeNode.textValue(), formatNode != null ? formatNode.textValue() : null, truncateExpectedNode != null ? truncateExpectedNode.textValue() : null, truncateActualNode != null ? truncateActualNode.textValue() : null, expectedOffsetAmountNode != null ? Integer.valueOf(expectedOffsetAmountNode.intValue()) : null, expectedOffsetUnitNode != null ? DateTimeUnit.valueOf(expectedOffsetUnitNode.textValue().toUpperCase()) : null);
            }
            case "equalToDateTime": {
                return new EqualToDateTimePattern(dateTimeNode.textValue(), formatNode != null ? formatNode.textValue() : null, truncateExpectedNode != null ? truncateExpectedNode.textValue() : null, truncateActualNode != null ? truncateActualNode.textValue() : null, expectedOffsetAmountNode != null ? Integer.valueOf(expectedOffsetAmountNode.intValue()) : null, expectedOffsetUnitNode != null ? DateTimeUnit.valueOf(expectedOffsetUnitNode.textValue().toUpperCase()) : null);
            }
        }
        throw new JsonMappingException(rootNode.toString() + " is not a valid match operation");
    }

    private LogicalAnd deserializeAnd(JsonNode node) throws JsonMappingException {
        JsonNode operandsNode = node.get("and");
        if (!operandsNode.isArray()) {
            throw new JsonMappingException("and field must be an array of matchers");
        }
        JsonParser parser = Json.getObjectMapper().treeAsTokens((TreeNode)node.get("and"));
        try {
            List operands = (List)parser.readValueAs((TypeReference)new TypeReference<List<StringValuePattern>>(){});
            return new LogicalAnd(operands);
        }
        catch (IOException e) {
            return Exceptions.throwUnchecked(e, LogicalAnd.class);
        }
    }

    private LogicalOr deserializeOr(JsonNode node) throws JsonMappingException {
        JsonNode operandsNode = node.get("or");
        if (!operandsNode.isArray()) {
            throw new JsonMappingException("and field must be an array of matchers");
        }
        JsonParser parser = Json.getObjectMapper().treeAsTokens((TreeNode)node.get("or"));
        try {
            List operands = (List)parser.readValueAs((TypeReference)new TypeReference<List<StringValuePattern>>(){});
            return new LogicalOr(operands);
        }
        catch (IOException e) {
            return Exceptions.throwUnchecked(e, LogicalOr.class);
        }
    }

    private static Map<String, String> toNamespaceMap(JsonNode namespacesNode) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Iterator fields = namespacesNode.fields();
        while (fields.hasNext()) {
            Map.Entry field = (Map.Entry)fields.next();
            builder.put((Object)((String)field.getKey()), (Object)((JsonNode)field.getValue()).textValue());
        }
        return builder.build();
    }

    private static Boolean fromNullable(JsonNode node) {
        return node == null ? null : Boolean.valueOf(node.asBoolean());
    }

    private static String fromNullableTextNode(JsonNode node) {
        return node == null ? null : node.asText();
    }

    private static Set<ComparisonType> comparisonTypeSetFromArray(JsonNode node) {
        if (node == null || !node.isArray()) {
            return null;
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (JsonNode itemNode : node) {
            builder.add((Object)ComparisonType.valueOf((String)itemNode.textValue()));
        }
        return builder.build();
    }

    private static Constructor<? extends StringValuePattern> findConstructor(Class<? extends StringValuePattern> clazz) {
        Optional optionalConstructor = Iterables.tryFind(Arrays.asList(clazz.getDeclaredConstructors()), (Predicate)new Predicate<Constructor<?>>(){

            public boolean apply(Constructor<?> input) {
                return input.getParameterTypes().length == 1 && input.getGenericParameterTypes()[0].equals(String.class);
            }
        });
        if (!optionalConstructor.isPresent()) {
            throw new IllegalStateException("Constructor for " + clazz.getSimpleName() + " must have a single string argument constructor");
        }
        return (Constructor)optionalConstructor.get();
    }

    private static boolean isAbsent(JsonNode rootNode) {
        for (Map.Entry node : ImmutableList.copyOf((Iterator)rootNode.fields())) {
            if (!((String)node.getKey()).equals("absent")) continue;
            return true;
        }
        return false;
    }

    private static Class<? extends StringValuePattern> findPatternClass(JsonNode rootNode) throws JsonMappingException {
        for (Map.Entry node : ImmutableList.copyOf((Iterator)rootNode.fields())) {
            Class<? extends StringValuePattern> patternClass = PATTERNS.get(node.getKey());
            if (patternClass == null) continue;
            return patternClass;
        }
        throw new JsonMappingException(rootNode.toString() + " is not a valid match operation");
    }
}

