/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.matching.MatchResult;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;

public abstract class AbstractDateTimeMatchResult
extends MatchResult {
    private final boolean isZoned;
    private final boolean isLocal;
    protected final LocalDateTime localExpected;
    protected final ZonedDateTime zonedExpected;
    protected final ZonedDateTime zonedActual;
    protected final LocalDateTime localActual;

    public AbstractDateTimeMatchResult(ZonedDateTime zonedExpected, LocalDateTime localExpected, ZonedDateTime zonedActual, LocalDateTime localActual) {
        this.zonedExpected = zonedExpected;
        this.localExpected = localExpected;
        this.isZoned = zonedExpected != null;
        this.isLocal = localExpected != null;
        this.zonedActual = zonedActual;
        this.localActual = localActual;
    }

    @Override
    public boolean isExactMatch() {
        boolean isMatch = false;
        if (this.isZoned && this.zonedActual != null) {
            isMatch = this.matchZonedZoned();
        } else if (this.isLocal && this.localActual != null) {
            isMatch = this.matchLocalLocal();
        } else if (this.isLocal && this.zonedActual != null) {
            isMatch = this.matchLocalZoned();
        } else if (this.isZoned && this.localActual != null) {
            isMatch = this.matchZonedLocal();
        }
        return isMatch;
    }

    protected abstract boolean matchZonedZoned();

    protected abstract boolean matchLocalLocal();

    protected abstract boolean matchLocalZoned();

    protected abstract boolean matchZonedLocal();

    @Override
    public double getDistance() {
        double distance = -1.0;
        if (this.isZoned && this.zonedActual != null) {
            distance = this.calculateDistance(this.zonedExpected, this.zonedActual);
        } else if (this.isLocal && this.localActual != null) {
            distance = this.calculateDistance(this.localExpected, this.localActual);
        } else if (this.isLocal && this.zonedActual != null) {
            distance = this.calculateDistance(this.localExpected, this.zonedActual.toLocalDateTime());
        }
        return distance;
    }

    private double calculateDistance(Temporal start, Temporal end) {
        double distance = (double)ChronoUnit.YEARS.between(start, end) / 100.0;
        distance = Math.abs(distance);
        return Math.min(distance, 1.0);
    }
}

