/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty9;

import com.github.tomakehurst.wiremock.common.Exceptions;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Dispatcher;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;

public class NotFoundHandler
extends ErrorHandler {
    private final ErrorHandler DEFAULT_HANDLER = new ErrorHandler();
    private final ContextHandler mockServiceHandler;

    public NotFoundHandler(ContextHandler mockServiceHandler) {
        this.mockServiceHandler = mockServiceHandler;
    }

    public boolean errorPageForMethod(String method) {
        return true;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (response.getStatus() == 404) {
            ServletContext adminContext = this.mockServiceHandler.getServletContext().getContext("/__admin");
            Dispatcher requestDispatcher = (Dispatcher)adminContext.getRequestDispatcher("/not-matched");
            try {
                requestDispatcher.error((ServletRequest)request, (ServletResponse)response);
            }
            catch (ServletException e) {
                Exceptions.throwUnchecked(e);
            }
        } else {
            try {
                this.DEFAULT_HANDLER.handle(target, baseRequest, request, response);
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                Exceptions.throwUnchecked(e);
            }
        }
    }
}

