/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.matching.EqualToPattern;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.recording.CaptureHeadersSpec;
import com.github.tomakehurst.wiremock.recording.RequestBodyPatternFactory;
import com.google.common.base.Function;
import java.util.Map;

public class RequestPatternTransformer
implements Function<Request, RequestPatternBuilder> {
    private final Map<String, CaptureHeadersSpec> headers;
    private final RequestBodyPatternFactory bodyPatternFactory;

    public RequestPatternTransformer(Map<String, CaptureHeadersSpec> headers, RequestBodyPatternFactory bodyPatternFactory) {
        this.headers = headers;
        this.bodyPatternFactory = bodyPatternFactory;
    }

    public RequestPatternBuilder apply(Request request) {
        RequestPatternBuilder builder = new RequestPatternBuilder(request.getMethod(), WireMock.urlEqualTo(request.getUrl()));
        if (this.headers != null && !this.headers.isEmpty()) {
            for (Map.Entry<String, CaptureHeadersSpec> header : this.headers.entrySet()) {
                String headerName = header.getKey();
                if (!request.containsHeader(headerName)) continue;
                CaptureHeadersSpec spec = header.getValue();
                EqualToPattern headerMatcher = new EqualToPattern(request.getHeader(headerName), spec.getCaseInsensitive());
                builder.withHeader(headerName, headerMatcher);
            }
        }
        byte[] body = request.getBody();
        if (this.bodyPatternFactory != null && body != null && body.length > 0) {
            builder.withRequestBody(this.bodyPatternFactory.forRequest(request));
        }
        return builder;
    }
}

