/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import java.util.function.Function;

public enum DateTimeTruncation {
    FIRST_SECOND_OF_MINUTE(input -> input.truncatedTo(ChronoUnit.MINUTES)),
    FIRST_MINUTE_OF_HOUR(input -> input.truncatedTo(ChronoUnit.HOURS)),
    FIRST_HOUR_OF_DAY(input -> input.truncatedTo(ChronoUnit.DAYS)),
    FIRST_DAY_OF_MONTH(input -> input.with(TemporalAdjusters.firstDayOfMonth()).truncatedTo(ChronoUnit.DAYS)),
    FIRST_DAY_OF_NEXT_MONTH(input -> input.with(TemporalAdjusters.firstDayOfNextMonth()).truncatedTo(ChronoUnit.DAYS)),
    LAST_DAY_OF_MONTH(input -> input.with(TemporalAdjusters.lastDayOfMonth()).truncatedTo(ChronoUnit.DAYS)),
    FIRST_DAY_OF_YEAR(input -> input.with(TemporalAdjusters.firstDayOfYear()).truncatedTo(ChronoUnit.DAYS)),
    FIRST_DAY_OF_NEXT_YEAR(input -> input.with(TemporalAdjusters.firstDayOfNextYear()).truncatedTo(ChronoUnit.DAYS)),
    LAST_DAY_OF_YEAR(input -> input.with(TemporalAdjusters.lastDayOfYear()).truncatedTo(ChronoUnit.DAYS));

    private final Function<ZonedDateTime, ZonedDateTime> fn;

    private DateTimeTruncation(Function<ZonedDateTime, ZonedDateTime> fn) {
        this.fn = fn;
    }

    public ZonedDateTime truncate(ZonedDateTime input) {
        return this.fn.apply(input);
    }

    public Date truncate(Date input) {
        ZonedDateTime zonedInput = input.toInstant().atZone(ZoneOffset.UTC);
        return Date.from(this.truncate(zonedInput).toInstant());
    }

    public String toString() {
        return this.name().replace('_', ' ').toLowerCase();
    }

    public static DateTimeTruncation fromString(String value) {
        String normalisedKey = value.toUpperCase().replace(' ', '_');
        return DateTimeTruncation.valueOf(normalisedKey);
    }
}

