/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.servlet;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.core.FaultInjector;
import java.io.IOException;
import wiremock.javax.servlet.http.HttpServletResponse;

public class NoFaultInjector
implements FaultInjector {
    private final HttpServletResponse httpServletResponse;

    public NoFaultInjector(HttpServletResponse httpServletResponse) {
        this.httpServletResponse = httpServletResponse;
    }

    @Override
    public void connectionResetByPeer() {
        this.sendError();
    }

    @Override
    public void emptyResponseAndCloseConnection() {
        this.sendError();
    }

    @Override
    public void malformedResponseChunk() {
        this.sendError();
    }

    @Override
    public void randomDataAndCloseConnection() {
        this.sendError();
    }

    private void sendError() {
        this.httpServletResponse.setStatus(418);
        try {
            this.httpServletResponse.getWriter().write("No fault injector is configured!");
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
    }
}

